% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_plot.R
\name{ssm_plot_circle}
\alias{ssm_plot_circle}
\title{Create a Circular Plot of SSM Results}
\usage{
ssm_plot_circle(
  ssm_object,
  amax = NULL,
  legend_font_size = 12,
  scale_font_size = 12,
  drop_lowfit = FALSE,
  repel = FALSE,
  angle_labels = NULL,
  palette = "Set2",
  vary_shapes = FALSE,
  ...
)
}
\arguments{
\item{ssm_object}{Required. The output of \code{ssm_analyze()}.}

\item{amax}{A positive real number corresponding to the radius of the circle.
It is used to scale the amplitude values and will determine which amplitude
labels are drawn.}

\item{legend_font_size}{A positive real number corresponding to the size (in
pt) of the text labels in the legend (default = 12).}

\item{scale_font_size}{A positive real number corresponding to the size (in
pt) of the text labels for the amplitude and displacement scales (default =
12).}

\item{drop_lowfit}{A logical determining whether profiles with low model fit
(<.70) should be omitted or plotted with dashed borders (default = FALSE).}

\item{repel}{An experimental argument for plotting text labels instead of
colors.}

\item{angle_labels}{A character vector specifying text labels to plot around
the circle for each scale. Can also specify NULL to default to numerical
angle labels or a vector of empty strings ("") to hide the labels. If not
NULL, must have the same length and ordering as the \code{angles} argument to
\code{ssm_analyze()}. (default = NULL)}

\item{palette}{A string corresponding to the palette to be used from
ColorBrewer for the color and fill aesthetics. If set to NULL, all points
will appear blue and no legend will be there (useful for showing the
coverage of a high number of variables).}

\item{vary_shapes}{A logical determining whether profiles should each get
their own shape or vary only by fill color. This only works when the number
of profiles is five or less. (default = FALSE)}

\item{...}{Currently ignored.}
}
\value{
A ggplot variable containing a completed circular plot.
}
\description{
Take in the results of a Structural Summary Method analysis and plot the
point and interval estimate for each row (e.g., group or measure) in a
circular space quantified by displacement and amplitude.
}
\examples{
\donttest{
data("jz2017")
res <- ssm_analyze(
  jz2017,
  scales = 2:9,
  measures = c("NARPD", "ASPD")
)
ssm_plot_circle(res)
}
}
