% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{tables_get_enhancements_cass_ncoa}
\alias{tables_get_enhancements_cass_ncoa}
\title{View the status of a CASS / NCOA table enhancement}
\usage{
tables_get_enhancements_cass_ncoa(id, source_table_id)
}
\arguments{
\item{id}{integer required. The ID of the enhancement.}

\item{source_table_id}{integer required. The ID of the table that was enhanced.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the enhancement.}
\item{sourceTableId}{integer, The ID of the table that was enhanced.}
\item{state}{string, The state of the enhancement, one of 'queued' 'running' 'succeeded' 'failed' or 'cancelled'.}
\item{enhancedTableSchema}{string, The schema name of the table created by the enhancement.}
\item{enhancedTableName}{string, The name of the table created by the enhancement.}
\item{performNcoa}{boolean, Whether to update addresses for records matching the National Change of Address (NCOA) database.}
\item{ncoaCredentialId}{integer, Credential to use when performing NCOA updates. Required if 'performNcoa' is true.}
\item{outputLevel}{string, The set of fields persisted by a CASS or NCOA enhancement.For CASS enhancements, one of 'cass' or 'all.'For NCOA enhancements, one of 'cass', 'ncoa' , 'coalesced' or 'all'.By default, all fields will be returned.}
\item{batchSize}{integer, The maximum number of records processed at a time. Note that this parameter is not available to all users.}
}
\description{
View the status of a CASS / NCOA table enhancement
}
