% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cja_get_calculatedmetrics.R
\name{cja_get_calculatedmetrics}
\alias{cja_get_calculatedmetrics}
\title{Get a list of calculated metrics.}
\usage{
cja_get_calculatedmetrics(
  expansion = NULL,
  includeType = "all",
  dataviewIds = NULL,
  ownerId = NULL,
  filterByIds = NULL,
  toBeUsedInRsid = NULL,
  locale = "en_US",
  favorite = NULL,
  approved = NULL,
  pagination = TRUE,
  limit = 10,
  page = 0,
  sortDirection = "DESC",
  sortProperty = NULL,
  debug = FALSE
)
}
\arguments{
\item{expansion}{Additional calculated metric metadata fields to include in the results:
"dataName" "approved" "favorite" "shares" "tags" "sharesFullName" "usageSummary"
"usageSummaryWithRelevancyScore" "reportSuiteName" "siteTitle" "ownerFullName"
"modified" "migratedIds" "isDeleted" "definition" "authorization" "compatibility"
"legacyId" "internal" "dataGroup" "categories".}

\item{includeType}{Include additional calculated metrics not owned by user. Available values are \code{all} (default),
\code{shared}, \code{templates}, \code{unauthorized}, \code{deleted}, \code{internal}, and \code{curatedItem}. The \code{all} option takes precedence over \code{shared}}

\item{dataviewIds}{Filter the list to only include calculated metrics tied to a specified dataviewId or
list of dataviewIds. Specify multiple dataviewIds as a vector (i.e., "\verb{dataviewIds = c("dataviewid_1", dataviewid_2",...dataviewid_n")}").
Use \code{\link{cja_get_dataviews}} to get a list of available \code{dataviewId} values.}

\item{ownerId}{Filter the list to only include calculated metrics owned by the specified loginId.}

\item{filterByIds}{Filter the list to only include calculated metrics in the specified list as
specified by a single string or as a vector of strings.}

\item{toBeUsedInRsid}{The data view where the calculated metric intended to be used.
This data view will be used to determine things like compatibility and permissions.
If it is not specified then the permissions will be calculated based on the union of all metrics
authorized in all groups the user belongs to. If the compatibility expansion is specified and toBeUsedInRsid
is not then the compatibility returned is based off the compatibility from the last time the calculated metric was saved.}

\item{locale}{The locale that system-named metrics should be returned in. Non-localized values will
be returned for title, name, description, etc. if a localized value is not available.}

\item{favorite}{Set to \code{TRUE} to only include calculated metrics that are favorites in the results. A
value of \code{FALSE} will return all calculated metrics, including those that are favorites.}

\item{approved}{Set to \code{TRUE} to only include calculated metrics that are approved in the results. A
value of \code{FALSE} will return all calculated metrics, including those that are approved and those that are not.}

\item{pagination}{return paginated results. Set to 'TRUE' by default}

\item{limit}{Number of results per page. Default is 10}

\item{page}{The "page" of results to display. This works in conjunction with the \code{limit} argument and is
zero-based. For instance, if \code{limit = 10} and \code{page = 1}, the results returned would be 11 through 20.}

\item{sortDirection}{The sort direction for the results: \code{ASC} (default) for ascending or \code{DESC} for
descending. (This is case insensitive, so \code{asc} and \code{desc} work as well.)}

\item{sortProperty}{The property to sort the results by. Currently available values are \code{id} (default), \code{name},
and \code{modified_date}. Note that setting \code{expansion = modified} returns results with a column added called
\code{modified}, which is the last date the calculated metric was modified. When using this value for \code{sortProperty},
though, the name of the argument is \code{modified_date}.}

\item{debug}{Include the output and input of the api call in the console for debugging. Default is FALSE}
}
\value{
A data frame of calculated metrics and their metadata.
}
\description{
Retrieve a list of available calculated metrics. The results will always include these default items:
\code{id}, \code{name}, \code{description}, \code{owner}, \code{polarity}, \code{precision}, \code{type}. Other attributes can
be optionally requested through the \code{expansion} field.
}
\details{
This function is useful/needed to identify the specific ID of a calculated metric for use in other
functions like \code{cja_freeform_report}.

The \code{expansion} argument accepts the following values, which will then include additional columns
in the results:
\itemize{
\item \strong{ownerFullName}: adds \code{owner.name} and \code{owner.login} columns to the results (\code{owner.id} is
already included by default).
\item \strong{modified}: adds a \code{modified} column to the output with the date (ISO 8601 format) each
calculated metric was last modified.
\item \strong{definition}: adds \emph{multiple} columns (the number will vary based on the number and complexity
of calculated metrics returns) that provide the actual formula for each of the calculated metrics.
This is returned from the API as a JSON object and converted into columns by the function, which
means it is pretty messy, so, really, it's not recommended that you use this value.
\item \strong{compatability}: should add a column with the products that the metric is compatible with, but this
behavior has not actually been shown to be true, so this may actually do nothing if included.
\item \strong{reportSuiteName}: adds a \code{reportSuiteName} and a \code{siteTitle} column with the friendly report
suite name for the RSID.
\item \strong{tags}: adds a column with an embedded data frame with all of the existing tags that are
associated with the calculated metric. This can be a bit messy to work with, but the information
is, at least, there.
}

Other Expansion options that are available: "dataName", "approved", "favorite",
"shares", "sharesFullName", "usageSummary", "usageSummaryWithRelevancyScore",
"siteTitle", "migratedIds", "isDeleted", "authorization", "legacyId",
"internal", "dataGroup", "categories"

Multiple values for \code{expansion} can be included in the argument as a vector. For instance,
\code{expansion = c("tags", "modified")} will add both a \code{tags} column and a \code{modified} column to the output.
}
\seealso{
\code{\link{cja_get_metrics}}
}
