% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windrose.R
\name{ggwindrose}
\alias{ggwindrose}
\title{Windrose (speed/direction) diagram}
\usage{
ggwindrose(
  speed,
  direction,
  n_directions = 8,
  n_speeds = 5,
  speed_cuts = NA,
  col_pal = "GnBu",
  legend_title = "Wind speed (m/s)",
  calm_wind = 0,
  n_col = 1,
  facet = NULL,
  plot_title = "",
  ...
)
}
\arguments{
\item{speed}{Numeric vector of wind speeds.}

\item{direction}{Numeric vector of wind directions.}

\item{n_directions}{Numeric value as the number of direction bins to plot
(petals on the rose). The number of directions defaults to \code{8}.}

\item{n_speeds}{Numeric value as the number of equally spaced wind speed
bins to plot. This is used if \code{speed_cuts} is \code{NA} (default \code{5}).}

\item{speed_cuts}{Numeric vector containing the cut points for the wind
speed intervals, or \code{NA} (default).}

\item{col_pal}{Character string indicating the name of the
\code{\link[=hcl.pals]{hcl.pals()}} color palette to be used for plotting.}

\item{legend_title}{Character string to be used for the legend title.}

\item{calm_wind}{Numeric value as the upper limit for wind speed that is
considered calm (default \code{0}).}

\item{n_col}{The number of columns of plots (default 1).}

\item{facet}{Character or factor vector of the facets used to plot the
various windroses.}

\item{plot_title}{Character string to be used for the plot title.}

\item{...}{further arguments (ignored).}
}
\value{
A \CRANpkg{ggplot2} object\code{.}
}
\description{
Plot a windrose showing the wind speed and direction using \CRANpkg{ggplot2}.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{


library(ggplot2)

speed <- climaemet::climaemet_9434_wind$velmedia
direction <- climaemet::climaemet_9434_wind$dir

rose <- ggwindrose(
  speed = speed,
  direction = direction,
  speed_cuts = seq(0, 16, 4),
  legend_title = "Wind speed (m/s)",
  calm_wind = 0,
  n_col = 1,
  plot_title = "Zaragoza Airport"
)
rose + labs(
  subtitle = "2000-2020",
  caption = "Source: AEMET"
)
}
\seealso{
\code{\link[ggplot2:theme]{ggplot2::theme()}} for more possible arguments to pass to
\code{ggwindrose}.

Other aemet_plots: 
\code{\link{climatestripes_station}()},
\code{\link{climatogram_normal}()},
\code{\link{climatogram_period}()},
\code{\link{ggclimat_walter_lieth}()},
\code{\link{ggstripes}()},
\code{\link{windrose_days}()},
\code{\link{windrose_period}()}

Other wind: 
\code{\link{climaemet_9434_wind}},
\code{\link{windrose_days}()},
\code{\link{windrose_period}()}
}
\concept{aemet_plots}
\concept{wind}
