% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.R
\name{identify_predictors}
\alias{identify_predictors}
\title{Identify Numeric and Categorical Predictors}
\usage{
identify_predictors(df = NULL, predictors = NULL)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}
}
\value{
list: names of numeric and categorical predictors
}
\description{
Returns a list with the names of the valid numeric predictors and the names of the valid categorical predictors
}
\examples{
if (interactive()) {

data(
  vi,
  vi_predictors
)

predictors_names <- identify_predictors(
  df = vi,
  predictors = vi_predictors
)

predictors_names

}
}
\seealso{
Other data_types: 
\code{\link{identify_predictors_categorical}()},
\code{\link{identify_predictors_numeric}()},
\code{\link{identify_predictors_type}()},
\code{\link{identify_predictors_zero_variance}()},
\code{\link{identify_response_type}()}
}
\author{
Blas M. Benito, PhD
}
\concept{data_types}
