% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_incove.R
\name{get_incove}
\alias{get_incove}
\title{Create an integrated co-occurrence vector (incove)}
\usage{
get_incove(x, ordered = TRUE, repeated = TRUE, normalization = "none")
}
\arguments{
\item{x}{A matrix - an output of the \code{\link[=get_incoma]{get_incoma()}} function}

\item{ordered}{The type of pairs considered.
Either "ordered" (TRUE) or "unordered" (FALSE).
The default is TRUE.
See details for more explanation.}

\item{repeated}{Should the repeated co-located co-occurrence matrices be used?
Either "repeated" (TRUE) or "unrepeated" (FALSE).
The default is TRUE.
See details for more explanation.}

\item{normalization}{Should the output vector be normalized?
Either "none" or "pdf".
The "pdf" option normalizes a vector to sum to one.
The default is "none".}
}
\value{
An integrated co-occurrence vector
}
\description{
Converts an integrated co-occurrence matrix (incoma) to
an integrated co-occurrence vector (incove)
}
\details{
All values are kept when \code{ordered = TRUE} and \code{repeated = TRUE}.
When \code{ordered = TRUE} and \code{repeated = FALSE} all values from cocoma (but only one cocoma for each pair) and all coma values are kept.
\code{ordered = FALSE} and \code{repeated = TRUE} keeps all values from cocoma, but divides coma values by 2.
\code{ordered = FALSE} and \code{repeated = FALSE} keeps all values from cocoma (but only one cocoma for each pair), and divides coma values by 2.
}
\examples{
library(comat)

data(raster_x, package = "comat")
data(raster_w, package = "comat")
x = list(raster_x, raster_w, raster_x)

incom = get_incoma(x)
incom

incov1 = get_incove(incom)
incov1

incov2 = get_incove(incom, ordered = FALSE)
incov2

incov3 = get_incove(incom, ordered = FALSE, normalization = "pdf")
incov3
}
