% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/dbi_methods.R, R/fs_methods.R
\name{tbl_cnt}
\alias{tbl_cnt}
\alias{tbl_cnt.ConnectorDBI}
\alias{tbl_cnt.ConnectorFS}
\title{Use dplyr verbs to interact with the remote database table}
\usage{
tbl_cnt(connector_object, name, ...)

\method{tbl_cnt}{ConnectorDBI}(connector_object, name, ...)

\method{tbl_cnt}{ConnectorFS}(connector_object, name, ...)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{name}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
A \link[dplyr:tbl]{dplyr::tbl} object.
}
\description{
Generic implementing of how to create a \code{\link[dplyr:tbl]{dplyr::tbl()}} connection in order
to use dplyr verbs to interact with the remote database table.
Mostly relevant for DBI connectors.

\itemize{
\item \link{ConnectorDBI}: Uses \code{\link[dplyr:tbl]{dplyr::tbl()}} to create a table reference to a table in a DBI connection.
}

\itemize{
\item \link{ConnectorFS}: Uses \code{read_cnt()} to allow redundancy between fs and dbi.
}
}
\examples{
# Use dplyr verbs on a table in a DBI database
cnt <- connector_dbi(RSQLite::SQLite())

iris_cnt <- cnt |>
  write_cnt(iris, "iris") |>
  tbl_cnt("iris")

iris_cnt

iris_cnt |>
  dplyr::collect()

iris_cnt |>
  dplyr::group_by(Species) |>
  dplyr::summarise(
    n = dplyr::n(),
    mean.Sepal.Length = mean(Sepal.Length, na.rm = TRUE)
  ) |>
  dplyr::collect()

# Use dplyr verbs on a table

folder <- withr::local_tempdir()
cnt <- connector_fs(folder)

cnt |>
  write_cnt(iris, "iris.csv")

iris_cnt <- cnt |>
  tbl_cnt("iris.csv")

iris_cnt

iris_cnt |>
  dplyr::group_by(Species) |>
  dplyr::summarise(
    n = dplyr::n(),
    mean.Sepal.Length = mean(Sepal.Length, na.rm = TRUE)
  )

}
