% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/dbi_methods.R, R/fs_methods.R
\name{write_cnt}
\alias{write_cnt}
\alias{write_cnt.ConnectorDBI}
\alias{write_cnt.ConnectorFS}
\title{Write content to the connector}
\usage{
write_cnt(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{write_cnt}{ConnectorDBI}(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)

\method{write_cnt}{ConnectorFS}(
  connector_object,
  x,
  name,
  overwrite = zephyr::get_option("overwrite", "connector"),
  ...
)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{x}{The object to write to the connection}

\item{name}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{overwrite}{Overwrite existing content if it exists in the connector?. Default: \code{FALSE}.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to write content to the different connector objects:

\itemize{
\item \link{ConnectorDBI}: Uses \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}} to write the table to the DBI connection.
}

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[=write_file]{write_file()}} to Write a file based on the file extension.
The underlying function used, and thereby also the arguments available
through \code{...} depends on the file extension.
}
}
\examples{
# Write table to DBI database
cnt <- connector_dbi(RSQLite::SQLite())

cnt |>
  list_content_cnt()

cnt |>
  write_cnt(iris, "iris")

cnt |>
  list_content_cnt()

# Write different file types to a file storage

folder <- withr::local_tempdir()
cnt <- connector_fs(folder)

cnt |>
  list_content_cnt(pattern = "iris")

# rds file
cnt |>
  write_cnt(iris, "iris.rds")

# CSV file
cnt |>
  write_cnt(iris, "iris.csv")

cnt |>
  list_content_cnt(pattern = "iris")

}
