% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeAdjustedSelectionUsingSplitMethod}
\alias{computeAdjustedSelectionUsingSplitMethod}
\title{Compute selection - split method}
\usage{
computeAdjustedSelectionUsingSplitMethod(dist, groups, preselected)
}
\arguments{
\item{dist}{distance matrix, used for distances and implicitly defining the set of entries}

\item{groups}{the initial division into group defined as a list of zero-based integers referring to the row/columns of \code{dist}}

\item{preselected}{the set of preselected entries}
}
\description{
The function \code{computeAdjustedSelectionUsingSplitMethod} is used internally by
the \code{\link{CoreCollection}} object to compute an adjusted selection using the split
method.
}
\details{
This function returns a list describing for each of the row/columns entries of \code{dist} the
corresponding entry referred to in \code{groups}. However, groups with one or multiple
\code{preselected} entries are divided, and the returned list wil contain references to
the closest preselected entry within this group, implying a split if multiple preselected
entries occur within one group. The entries are implicetly defined by the row/columns of
\code{dist} and referred to by a zero-based integer describing the position.
}
\keyword{internal}
