# set
testthat::test_that("set merge integer", {
  x <- cpp_set(4:9)
  y <- cpp_set(8:11)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), 4:11)
  testthat::expect_equal(to_r(y), 8:9)
})
testthat::test_that("set merge double", {
  x <- cpp_set(seq.int(1, 2, 0.5))
  y <- cpp_set(seq.int(1.5, 2.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), seq.int(1, 2.5, 0.5))
  testthat::expect_equal(to_r(y), seq.int(1.5, 2, 0.5))
})
testthat::test_that("set merge string", {
  x <- cpp_set(c("hello", "there"))
  y <- cpp_set(c("there", "R", "world"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), c("R", "hello", "there", "world"))
  testthat::expect_equal(to_r(y), "there")
})
testthat::test_that("set merge boolean", {
  x <- cpp_set(TRUE)
  y <- cpp_set(c(TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), c(FALSE, TRUE))
  testthat::expect_equal(to_r(y), TRUE)
})

# unordered_set
testthat::test_that("unordered_set merge integer", {
  x <- cpp_unordered_set(4:9)
  y <- cpp_unordered_set(8:11)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), 4:11)
  testthat::expect_setequal(to_r(y), 8:9)
})
testthat::test_that("unordered_set merge double", {
  x <- cpp_unordered_set(seq.int(1, 2, 0.5))
  y <- cpp_unordered_set(seq.int(1.5, 2.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), seq.int(1, 2.5, 0.5))
  testthat::expect_setequal(to_r(y), seq.int(1.5, 2, 0.5))
})
testthat::test_that("unordered_set merge string", {
  x <- cpp_unordered_set(c("hello", "there"))
  y <- cpp_unordered_set(c("there", "R", "world"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c("R", "hello", "there", "world"))
  testthat::expect_setequal(to_r(y), "there")
})
testthat::test_that("unordered_set merge boolean", {
  x <- cpp_unordered_set(TRUE)
  y <- cpp_unordered_set(c(TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(FALSE, TRUE))
  testthat::expect_setequal(to_r(y), TRUE)
})

# multiset
testthat::test_that("multiset merge integer", {
  x <- cpp_multiset(4:9)
  y <- cpp_multiset(8:11)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), c(4:8, 8:9, 9:11))
  testthat::expect_true(empty(y))
})
testthat::test_that("multiset merge double", {
  x <- cpp_multiset(seq.int(1, 2, 0.5))
  y <- cpp_multiset(seq.int(1.5, 2.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), c(1, 1.5, 1.5, 2, 2, 2.5))
  testthat::expect_true(empty(y))
})
testthat::test_that("multiset merge string", {
  x <- cpp_multiset(c("hello", "there"))
  y <- cpp_multiset(c("there", "R", "world"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), c("R", "hello", "there", "there", "world"))
  testthat::expect_true(empty(y))
})
testthat::test_that("multiset merge boolean", {
  x <- cpp_multiset(TRUE)
  y <- cpp_multiset(c(TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), c(FALSE, TRUE, TRUE))
  testthat::expect_true(empty(y))
})

# unordered_multiset
testthat::test_that("unordered_multiset merge integer", {
  x <- cpp_unordered_multiset(4:9)
  y <- cpp_unordered_multiset(8:11)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(4:8, 8:9, 9:11))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multiset merge double", {
  x <- cpp_unordered_multiset(seq.int(1, 2, 0.5))
  y <- cpp_unordered_multiset(seq.int(1.5, 2.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(1, 1.5, 1.5, 2, 2, 2.5))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multiset merge string", {
  x <- cpp_unordered_multiset(c("hello", "there"))
  y <- cpp_unordered_multiset(c("there", "R", "world"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c("R", "hello", "there", "there", "world"))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multiset merge boolean", {
  x <- cpp_unordered_multiset(TRUE)
  y <- cpp_unordered_multiset(c(TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(FALSE, TRUE, TRUE))
  testthat::expect_true(empty(y))
})

# map
testthat::test_that("map merge integer integer", {
  x <- cpp_map(4:9, 12:17)
  y <- cpp_map(8:11, 11:14)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = 4:11, value = c(12:17, 13:14)))
  testthat::expect_equal(to_r(y), data.frame(key = 8:9, value = 11:12))
})
testthat::test_that("map merge integer double", {
  x <- cpp_map(4:9, seq.int(1, 3.5, 0.5))
  y <- cpp_map(8:11, seq.int(3, 4.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = 4:11, value = seq.int(1, 4.5, 0.5)))
  testthat::expect_equal(to_r(y), data.frame(key = 8:9, value = c(3, 3.5)))
})
testthat::test_that("map merge integer string", {
  x <- cpp_map(6:9, c("hello", "there", "coding", "world"))
  y <- cpp_map(8:11, c("a", "quick", "R", "test"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = 6:11, value = c("hello", "there", "coding", "world", "R", "test")))
  testthat::expect_equal(to_r(y), data.frame(key = 8:9, value = c("a", "quick")))
})
testthat::test_that("map merge integer boolean", {
  x <- cpp_map(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  y <- cpp_map(8:11, c(TRUE, FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = 4:11, value = c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE)))
  testthat::expect_equal(to_r(y), data.frame(key = 8:9, value = c(TRUE, FALSE)))
})
testthat::test_that("map merge double integer", {
  x <- cpp_map(seq.int(1, 2.5, 0.5), 13:16)
  y <- cpp_map(seq.int(2, 3, 0.5), 11:13)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = seq.int(1, 3, 0.5), value = c(13:16, 13L)))
  testthat::expect_equal(to_r(y), data.frame(key = c(2, 2.5), value = 11:12))
})
testthat::test_that("map merge double double", {
  x <- cpp_map(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  y <- cpp_map(seq.int(2, 3, 0.5), seq.int(4.3, 4.7, 0.2))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = seq.int(1, 3, 0.5), value = c(seq.int(4, 4.3, 0.1), 4.7)))
  testthat::expect_equal(to_r(y), data.frame(key = c(2, 2.5), value = c(4.3, 4.5)))
})
testthat::test_that("map merge double string", {
  x <- cpp_map(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  y <- cpp_map(seq.int(2, 3, 0.5), c("in", "this", "package"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = seq.int(1, 3, 0.5), value = c("A", "quick", "unit", "test", "package")))
  testthat::expect_equal(to_r(y), data.frame(key = c(2, 2.5), value = c("in", "this")))
})
testthat::test_that("map merge double boolean", {
  x <- cpp_map(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_map(seq.int(2, 3, 0.5), c(FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = seq.int(1, 3, 0.5), value = c(TRUE, FALSE, FALSE, TRUE, FALSE)))
  testthat::expect_equal(to_r(y), data.frame(key = c(2, 2.5), value = c(FALSE, TRUE)))
})
testthat::test_that("map merge string integer", {
  x <- cpp_map(c("a", "b", "c", "d"), 13:16)
  y <- cpp_map(c("c", "d", "e"), 11:13)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c("a", "b", "c", "d", "e"), value = c(13:16, 13L)))
  testthat::expect_equal(to_r(y), data.frame(key = c("c", "d"), value = 11:12))
})
testthat::test_that("map merge string double", {
  x <- cpp_map(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  y <- cpp_map(c("c", "d", "e"), seq.int(4.3, 4.7, 0.2))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c("a", "b", "c", "d", "e"), value = c(seq.int(4, 4.3, 0.1), 4.7)))
  testthat::expect_equal(to_r(y), data.frame(key = c("c", "d"), value = c(4.3, 4.5)))
})
testthat::test_that("map merge string string", {
  x <- cpp_map(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  y <- cpp_map(c("c", "d", "e"), c("in", "this", "package"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c("a", "b", "c", "d", "e"), value = c("A", "quick", "unit", "test", "package")))
  testthat::expect_equal(to_r(y), data.frame(key = c("c", "d"), value = c("in", "this")))
})
testthat::test_that("map merge string boolean", {
  x <- cpp_map(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_map(c("c", "d", "e"), c(FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c("a", "b", "c", "d", "e"), value = c(TRUE, FALSE, FALSE, TRUE, FALSE)))
  testthat::expect_equal(to_r(y), data.frame(key = c("c", "d"), value = c(FALSE, TRUE)))
})
testthat::test_that("map merge boolean integer", {
  x <- cpp_map(TRUE, 13L)
  y <- cpp_map(c(TRUE, FALSE), 11:12)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(FALSE, TRUE), value = 12:13))
  testthat::expect_equal(to_r(y), data.frame(key = TRUE, value = 11L))
})
testthat::test_that("map merge boolean double", {
  x <- cpp_map(TRUE, 4)
  y <- cpp_map(c(TRUE, FALSE), c(4.3, 4.7))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(FALSE, TRUE), value = c(4.7, 4)))
  testthat::expect_equal(to_r(y), data.frame(key = TRUE, value = 4.3))
})
testthat::test_that("map merge boolean string", {
  x <- cpp_map(TRUE, "A")
  y <- cpp_map(c(TRUE, FALSE), c("in", "this"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(FALSE, TRUE), value = c("this", "A")))
  testthat::expect_equal(to_r(y), data.frame(key = TRUE, value = "in"))
})
testthat::test_that("map merge boolean boolean", {
  x <- cpp_map(TRUE, TRUE)
  y <- cpp_map(c(TRUE, FALSE), c(FALSE, TRUE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(FALSE, TRUE), value = c(TRUE, TRUE)))
  testthat::expect_equal(to_r(y), data.frame(key = TRUE, value = FALSE))
})

# unordered_map
testthat::test_that("unordered_map merge integer integer", {
  x <- cpp_unordered_map(4:9, 12:17)
  y <- cpp_unordered_map(8:11, 11:14)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, 4:11)
  testthat::expect_setequal(to_r(y)$key, 8:9)
})
testthat::test_that("unordered_map merge integer double", {
  x <- cpp_unordered_map(4:9, seq.int(1, 3.5, 0.5))
  y <- cpp_unordered_map(8:11, seq.int(3, 4.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, 4:11)
  testthat::expect_setequal(to_r(y)$key, 8:9)
})
testthat::test_that("unordered_map merge integer string", {
  x <- cpp_unordered_map(6:9, c("hello", "there", "coding", "world"))
  y <- cpp_unordered_map(8:11, c("a", "quick", "R", "test"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, 6:11)
  testthat::expect_setequal(to_r(y)$key, 8:9)
})
testthat::test_that("unordered_map merge integer boolean", {
  x <- cpp_unordered_map(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  y <- cpp_unordered_map(8:11, c(TRUE, FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, 4:11)
  testthat::expect_setequal(to_r(y)$key, 8:9)
})
testthat::test_that("unordered_map merge double integer", {
  x <- cpp_unordered_map(seq.int(1, 2.5, 0.5), 13:16)
  y <- cpp_unordered_map(seq.int(2, 3, 0.5), 11:13)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, seq.int(1, 3, 0.5))
  testthat::expect_setequal(to_r(y)$key, c(2, 2.5))
})
testthat::test_that("unordered_map merge double double", {
  x <- cpp_unordered_map(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  y <- cpp_unordered_map(seq.int(2, 3, 0.5), seq.int(4.3, 4.7, 0.2))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, seq.int(1, 3, 0.5))
  testthat::expect_setequal(to_r(y)$key, c(2, 2.5))
})
testthat::test_that("unordered_map merge double string", {
  x <- cpp_unordered_map(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  y <- cpp_unordered_map(seq.int(2, 3, 0.5), c("in", "this", "package"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, seq.int(1, 3, 0.5))
  testthat::expect_setequal(to_r(y)$key, c(2, 2.5))
})
testthat::test_that("unordered_map merge double boolean", {
  x <- cpp_unordered_map(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_unordered_map(seq.int(2, 3, 0.5), c(FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, seq.int(1, 3, 0.5))
  testthat::expect_setequal(to_r(y)$key, c(2, 2.5))
})
testthat::test_that("unordered_map merge string integer", {
  x <- cpp_unordered_map(c("a", "b", "c", "d"), 13:16)
  y <- cpp_unordered_map(c("c", "d", "e"), 11:13)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c("a", "b", "c", "d", "e"))
  testthat::expect_setequal(to_r(y)$key, c("c", "d"))
})
testthat::test_that("unordered_map merge string double", {
  x <- cpp_unordered_map(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  y <- cpp_unordered_map(c("c", "d", "e"), seq.int(4.3, 4.7, 0.2))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c("a", "b", "c", "d", "e"))
  testthat::expect_setequal(to_r(y)$key, c("c", "d"))
})
testthat::test_that("unordered_map merge string string", {
  x <- cpp_unordered_map(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  y <- cpp_unordered_map(c("c", "d", "e"), c("in", "this", "package"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c("a", "b", "c", "d", "e"))
  testthat::expect_setequal(to_r(y)$key, c("c", "d"))
})
testthat::test_that("unordered_map merge string boolean", {
  x <- cpp_unordered_map(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_unordered_map(c("c", "d", "e"), c(FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c("a", "b", "c", "d", "e"))
  testthat::expect_setequal(to_r(y)$key, c("c", "d"))
})
testthat::test_that("unordered_map merge boolean integer", {
  x <- cpp_unordered_map(TRUE, 13L)
  y <- cpp_unordered_map(c(TRUE, FALSE), 11:12)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(FALSE, TRUE))
  testthat::expect_setequal(to_r(y)$key, TRUE)
})
testthat::test_that("unordered_map merge boolean double", {
  x <- cpp_unordered_map(TRUE, 4)
  y <- cpp_unordered_map(c(TRUE, FALSE), c(4.3, 4.7))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(FALSE, TRUE))
  testthat::expect_setequal(to_r(y)$key, TRUE)
})
testthat::test_that("unordered_map merge boolean string", {
  x <- cpp_unordered_map(TRUE, "A")
  y <- cpp_unordered_map(c(TRUE, FALSE), c("in", "this"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(FALSE, TRUE))
  testthat::expect_setequal(to_r(y)$key, TRUE)
})
testthat::test_that("unordered_map merge boolean boolean", {
  x <- cpp_unordered_map(TRUE, TRUE)
  y <- cpp_unordered_map(c(TRUE, FALSE), c(FALSE, TRUE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(FALSE, TRUE))
  testthat::expect_setequal(to_r(y)$key, TRUE)
})

# multimap
testthat::test_that("multimap merge integer integer", {
  x <- cpp_multimap(4:9, 12:17)
  y <- cpp_multimap(8:11, 11:14)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(4:8, 8:9, 9:11), value = c(12:16, 11L, 17L, 12:14)))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge integer double", {
  x <- cpp_multimap(4:9, seq.int(1, 3.5, 0.5))
  y <- cpp_multimap(8:11, seq.int(3, 4.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(4:8, 8:9, 9:11), value = c(seq.int(1, 3, 0.5), 3, 3.5, seq.int(3.5, 4.5, 0.5))))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge integer string", {
  x <- cpp_multimap(6:9, c("hello", "there", "coding", "world"))
  y <- cpp_multimap(8:11, c("a", "quick", "R", "test"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(6:8, 8:9, 9:11), value = c("hello", "there", "coding", "a", "world", "quick", "R", "test")))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge integer boolean", {
  x <- cpp_multimap(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  y <- cpp_multimap(8:11, c(TRUE, FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(4:8, 8:9, 9:11), value = c(TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE)))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge double integer", {
  x <- cpp_multimap(seq.int(1, 2.5, 0.5), 13:16)
  y <- cpp_multimap(seq.int(2, 3, 0.5), 11:13)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(seq.int(1, 2, 0.5), 2, 2.5, seq.int(2.5, 3, 0.5)), value = c(13:15, 11L, 16L, 12:13)))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge double double", {
  x <- cpp_multimap(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  y <- cpp_multimap(seq.int(2, 3, 0.5), seq.int(4.3, 4.7, 0.2))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(seq.int(1, 2, 0.5), 2, 2.5, seq.int(2.5, 3, 0.5)), value = c(seq.int(4, 4.3, 0.1), seq.int(4.3, 4.7,
    0.2))))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge double string", {
  x <- cpp_multimap(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  y <- cpp_multimap(seq.int(2, 3, 0.5), c("in", "this", "package"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(seq.int(1, 2, 0.5), 2, 2.5, seq.int(2.5, 3, 0.5)), value = c("A", "quick", "unit", "in", "test",
    "this", "package")))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge double boolean", {
  x <- cpp_multimap(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_multimap(seq.int(2, 3, 0.5), c(FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(seq.int(1, 2, 0.5), 2, 2.5, seq.int(2.5, 3, 0.5)), value = c(TRUE, FALSE, FALSE, FALSE, TRUE, TRUE,
    FALSE)))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge string integer", {
  x <- cpp_multimap(c("a", "b", "c", "d"), 13:16)
  y <- cpp_multimap(c("c", "d", "e"), 11:13)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c("a", "b", "c", "c", "d", "d", "e"), value = c(13:15, 11L, 16L, 12:13)))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge string double", {
  x <- cpp_multimap(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  y <- cpp_multimap(c("c", "d", "e"), seq.int(4.3, 4.7, 0.2))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c("a", "b", "c", "c", "d", "d", "e"), value = c(seq.int(4, 4.3, 0.1), seq.int(4.3, 4.7, 0.2))))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge string string", {
  x <- cpp_multimap(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  y <- cpp_multimap(c("c", "d", "e"), c("in", "this", "package"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c("a", "b", "c", "c", "d", "d", "e"), value = c("A", "quick", "unit", "in", "test", "this", "package")))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge string boolean", {
  x <- cpp_multimap(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_multimap(c("c", "d", "e"), c(FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c("a", "b", "c", "c", "d", "d", "e"), value = c(TRUE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE)))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge boolean integer", {
  x <- cpp_multimap(TRUE, 13L)
  y <- cpp_multimap(c(TRUE, FALSE), 11:12)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(FALSE, TRUE, TRUE), value = c(12:13, 11L)))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge boolean double", {
  x <- cpp_multimap(TRUE, 4)
  y <- cpp_multimap(c(TRUE, FALSE), c(4.3, 4.7))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(FALSE, TRUE, TRUE), value = c(4.7, 4, 4.3)))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge boolean string", {
  x <- cpp_multimap(TRUE, "A")
  y <- cpp_multimap(c(TRUE, FALSE), c("in", "this"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(FALSE, TRUE, TRUE), value = c("this", "A", "in")))
  testthat::expect_true(empty(y))
})
testthat::test_that("multimap merge boolean boolean", {
  x <- cpp_multimap(TRUE, TRUE)
  y <- cpp_multimap(c(TRUE, FALSE), c(FALSE, TRUE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_equal(to_r(x), data.frame(key = c(FALSE, TRUE, TRUE), value = c(TRUE, TRUE, FALSE)))
  testthat::expect_true(empty(y))
})

# unordered_multimap
testthat::test_that("unordered_multimap merge integer integer", {
  x <- cpp_unordered_multimap(4:9, 12:17)
  y <- cpp_unordered_multimap(8:11, 11:14)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(4:11, 8:11))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge integer double", {
  x <- cpp_unordered_multimap(4:9, seq.int(1, 3.5, 0.5))
  y <- cpp_unordered_multimap(8:11, seq.int(3, 4.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(4:11, 8:11))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge integer string", {
  x <- cpp_unordered_multimap(6:9, c("hello", "there", "coding", "world"))
  y <- cpp_unordered_multimap(8:11, c("a", "quick", "R", "test"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(6:11, 8:11))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge integer boolean", {
  x <- cpp_unordered_multimap(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  y <- cpp_unordered_multimap(8:11, c(TRUE, FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(4:11, 8:11))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge double integer", {
  x <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), 13:16)
  y <- cpp_unordered_multimap(seq.int(2, 3, 0.5), 11:13)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(seq.int(1, 3, 0.5), seq.int(2, 3, 0.5)))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge double double", {
  x <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  y <- cpp_unordered_multimap(seq.int(2, 3, 0.5), seq.int(4.3, 4.7, 0.2))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(seq.int(1, 3, 0.5), seq.int(2, 3, 0.5)))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge double string", {
  x <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  y <- cpp_unordered_multimap(seq.int(2, 3, 0.5), c("in", "this", "package"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(seq.int(1, 3, 0.5), seq.int(2, 3, 0.5)))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge double boolean", {
  x <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_unordered_multimap(seq.int(2, 3, 0.5), c(FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(seq.int(1, 3, 0.5), seq.int(2, 3, 0.5)))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge string integer", {
  x <- cpp_unordered_multimap(c("a", "b", "c", "d"), 13:16)
  y <- cpp_unordered_multimap(c("c", "d", "e"), 11:13)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c("a", "b", "c", "d", "e", "c", "d", "e"))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge string double", {
  x <- cpp_unordered_multimap(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  y <- cpp_unordered_multimap(c("c", "d", "e"), seq.int(4.3, 4.7, 0.2))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c("a", "b", "c", "d", "e", "c", "d", "e"))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge string string", {
  x <- cpp_unordered_multimap(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  y <- cpp_unordered_multimap(c("c", "d", "e"), c("in", "this", "package"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c("a", "b", "c", "d", "e", "c", "d", "e"))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge string boolean", {
  x <- cpp_unordered_multimap(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_unordered_multimap(c("c", "d", "e"), c(FALSE, TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c("a", "b", "c", "d", "e", "c", "d", "e"))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge boolean integer", {
  x <- cpp_unordered_multimap(TRUE, 13L)
  y <- cpp_unordered_multimap(c(TRUE, FALSE), 11:12)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(FALSE, TRUE, TRUE))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge boolean double", {
  x <- cpp_unordered_multimap(TRUE, 4)
  y <- cpp_unordered_multimap(c(TRUE, FALSE), c(4.3, 4.7))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(FALSE, TRUE, TRUE))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge boolean string", {
  x <- cpp_unordered_multimap(TRUE, "A")
  y <- cpp_unordered_multimap(c(TRUE, FALSE), c("in", "this"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(FALSE, TRUE, TRUE))
  testthat::expect_true(empty(y))
})
testthat::test_that("unordered_multimap merge boolean boolean", {
  x <- cpp_unordered_multimap(TRUE, TRUE)
  y <- cpp_unordered_multimap(c(TRUE, FALSE), c(FALSE, TRUE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x)$key, c(FALSE, TRUE, TRUE))
  testthat::expect_true(empty(y))
})

# forward_list
testthat::test_that("forward_list merge integer", {
  x <- cpp_forward_list(4:9)
  y <- cpp_forward_list(8:11)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(4:11, 8:9))
  testthat::expect_true(empty(y))
})
testthat::test_that("forward_list merge double", {
  x <- cpp_forward_list(seq.int(1, 2, 0.5))
  y <- cpp_forward_list(seq.int(1.5, 2.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(seq.int(1, 2.5, 0.5), seq.int(1.5, 2, 0.5)))
  testthat::expect_true(empty(y))
})
testthat::test_that("forward_list merge string", {
  x <- cpp_forward_list(c("hello", "there"))
  y <- cpp_forward_list(c("there", "R", "world"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c("R", "hello", "there", "there", "world"))
  testthat::expect_true(empty(y))
})
testthat::test_that("forward_list merge boolean", {
  x <- cpp_forward_list(TRUE)
  y <- cpp_forward_list(c(TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(FALSE, TRUE, TRUE))
  testthat::expect_true(empty(y))
})

# list
testthat::test_that("list merge integer", {
  x <- cpp_list(4:9)
  y <- cpp_list(8:11)
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(4:11, 8:9))
  testthat::expect_true(empty(y))
})
testthat::test_that("list merge double", {
  x <- cpp_list(seq.int(1, 2, 0.5))
  y <- cpp_list(seq.int(1.5, 2.5, 0.5))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(seq.int(1, 2.5, 0.5), seq.int(1.5, 2, 0.5)))
  testthat::expect_true(empty(y))
})
testthat::test_that("list merge string", {
  x <- cpp_list(c("hello", "there"))
  y <- cpp_list(c("there", "R", "world"))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c("R", "hello", "there", "there", "world"))
  testthat::expect_true(empty(y))
})
testthat::test_that("list merge boolean", {
  x <- cpp_list(TRUE)
  y <- cpp_list(c(TRUE, FALSE))
  testthat::expect_invisible(merge(x, y))
  testthat::expect_setequal(to_r(x), c(FALSE, TRUE, TRUE))
  testthat::expect_true(empty(y))
})
