skip_on_os("mac")
# set
testthat::test_that("set == integer", {
  x <- cpp_set(4:9)
  y <- cpp_set(4:9)
  z <- cpp_set(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("set == double", {
  x <- cpp_set(seq.int(1, 2, 0.5))
  y <- cpp_set(seq.int(1, 2, 0.5))
  z <- cpp_set(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("set == string", {
  x <- cpp_set(c("hello", "there"))
  y <- cpp_set(c("hello", "there"))
  z <- cpp_set(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("set == boolean", {
  x <- cpp_set(TRUE)
  y <- cpp_set(TRUE)
  z <- cpp_set(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# unordered_set
testthat::test_that("unordered_set == integer", {
  x <- cpp_unordered_set(4:9)
  y <- cpp_unordered_set(4:9)
  z <- cpp_unordered_set(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_set == double", {
  x <- cpp_unordered_set(seq.int(1, 2, 0.5))
  y <- cpp_unordered_set(seq.int(1, 2, 0.5))
  z <- cpp_unordered_set(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_set == string", {
  x <- cpp_unordered_set(c("hello", "there"))
  y <- cpp_unordered_set(c("hello", "there"))
  z <- cpp_unordered_set(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_set == boolean", {
  x <- cpp_unordered_set(TRUE)
  y <- cpp_unordered_set(TRUE)
  z <- cpp_unordered_set(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# multiset
testthat::test_that("multiset == integer", {
  x <- cpp_multiset(4:9)
  y <- cpp_multiset(4:9)
  z <- cpp_multiset(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multiset == double", {
  x <- cpp_multiset(seq.int(1, 2, 0.5))
  y <- cpp_multiset(seq.int(1, 2, 0.5))
  z <- cpp_multiset(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multiset == string", {
  x <- cpp_multiset(c("hello", "there"))
  y <- cpp_multiset(c("hello", "there"))
  z <- cpp_multiset(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multiset == boolean", {
  x <- cpp_multiset(TRUE)
  y <- cpp_multiset(TRUE)
  z <- cpp_multiset(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# unordered_multiset
testthat::test_that("unordered_multiset == integer", {
  x <- cpp_unordered_multiset(4:9)
  y <- cpp_unordered_multiset(4:9)
  z <- cpp_unordered_multiset(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multiset == double", {
  x <- cpp_unordered_multiset(seq.int(1, 2, 0.5))
  y <- cpp_unordered_multiset(seq.int(1, 2, 0.5))
  z <- cpp_unordered_multiset(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multiset == string", {
  x <- cpp_unordered_multiset(c("hello", "there"))
  y <- cpp_unordered_multiset(c("hello", "there"))
  z <- cpp_unordered_multiset(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multiset == boolean", {
  x <- cpp_unordered_multiset(TRUE)
  y <- cpp_unordered_multiset(TRUE)
  z <- cpp_unordered_multiset(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# map
testthat::test_that("map == integer integer", {
  x <- cpp_map(4:9, 12:17)
  y <- cpp_map(4:9, 12:17)
  z <- cpp_map(8:11, 11:14)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == integer double", {
  x <- cpp_map(4:9, seq.int(1, 3.5, 0.5))
  y <- cpp_map(4:9, seq.int(1, 3.5, 0.5))
  z <- cpp_map(8:11, seq.int(3, 4.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == integer string", {
  x <- cpp_map(6:9, c("hello", "there", "coding", "world"))
  y <- cpp_map(6:9, c("hello", "there", "coding", "world"))
  z <- cpp_map(8:11, c("a", "quick", "R", "test"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == integer boolean", {
  x <- cpp_map(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  y <- cpp_map(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  z <- cpp_map(8:11, c(TRUE, FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == double integer", {
  x <- cpp_map(seq.int(1, 2.5, 0.5), 13:16)
  y <- cpp_map(seq.int(1, 2.5, 0.5), 13:16)
  z <- cpp_map(seq.int(2, 3, 0.5), 11:13)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == double double", {
  x <- cpp_map(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  y <- cpp_map(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  z <- cpp_map(seq.int(2, 3, 0.5), seq.int(4.3, 4.7, 0.2))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == double string", {
  x <- cpp_map(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  y <- cpp_map(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  z <- cpp_map(seq.int(2, 3, 0.5), c("in", "this", "package"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == double boolean", {
  x <- cpp_map(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_map(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  z <- cpp_map(seq.int(2, 3, 0.5), c(FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == string integer", {
  x <- cpp_map(c("a", "b", "c", "d"), 13:16)
  y <- cpp_map(c("a", "b", "c", "d"), 13:16)
  z <- cpp_map(c("c", "d", "e"), 11:13)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == string double", {
  x <- cpp_map(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  y <- cpp_map(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  z <- cpp_map(c("c", "d", "e"), seq.int(4.3, 4.7, 0.2))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == string string", {
  x <- cpp_map(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  y <- cpp_map(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  z <- cpp_map(c("c", "d", "e"), c("in", "this", "package"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == string boolean", {
  x <- cpp_map(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_map(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  z <- cpp_map(c("c", "d", "e"), c(FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == boolean integer", {
  x <- cpp_map(TRUE, 13L)
  y <- cpp_map(TRUE, 13L)
  z <- cpp_map(c(TRUE, FALSE), 11:12)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == boolean double", {
  x <- cpp_map(TRUE, 4)
  y <- cpp_map(TRUE, 4)
  z <- cpp_map(c(TRUE, FALSE), c(4.3, 4.7))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == boolean string", {
  x <- cpp_map(TRUE, "A")
  y <- cpp_map(TRUE, "A")
  z <- cpp_map(c(TRUE, FALSE), c("in", "this"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("map == boolean boolean", {
  x <- cpp_map(TRUE, TRUE)
  y <- cpp_map(TRUE, TRUE)
  z <- cpp_map(c(TRUE, FALSE), c(FALSE, TRUE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# unordered_map
testthat::test_that("unordered_map == integer integer", {
  x <- cpp_unordered_map(4:9, 12:17)
  y <- cpp_unordered_map(4:9, 12:17)
  z <- cpp_unordered_map(8:11, 11:14)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == integer double", {
  x <- cpp_unordered_map(4:9, seq.int(1, 3.5, 0.5))
  y <- cpp_unordered_map(4:9, seq.int(1, 3.5, 0.5))
  z <- cpp_unordered_map(8:11, seq.int(3, 4.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == integer string", {
  x <- cpp_unordered_map(6:9, c("hello", "there", "coding", "world"))
  y <- cpp_unordered_map(6:9, c("hello", "there", "coding", "world"))
  z <- cpp_unordered_map(8:11, c("a", "quick", "R", "test"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == integer boolean", {
  x <- cpp_unordered_map(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  y <- cpp_unordered_map(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  z <- cpp_unordered_map(8:11, c(TRUE, FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == double integer", {
  x <- cpp_unordered_map(seq.int(1, 2.5, 0.5), 13:16)
  y <- cpp_unordered_map(seq.int(1, 2.5, 0.5), 13:16)
  z <- cpp_unordered_map(seq.int(2, 3, 0.5), 11:13)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == double double", {
  x <- cpp_unordered_map(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  y <- cpp_unordered_map(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  z <- cpp_unordered_map(seq.int(2, 3, 0.5), seq.int(4.3, 4.7, 0.2))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == double string", {
  x <- cpp_unordered_map(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  y <- cpp_unordered_map(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  z <- cpp_unordered_map(seq.int(2, 3, 0.5), c("in", "this", "package"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == double boolean", {
  x <- cpp_unordered_map(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_unordered_map(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  z <- cpp_unordered_map(seq.int(2, 3, 0.5), c(FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == string integer", {
  x <- cpp_unordered_map(c("a", "b", "c", "d"), 13:16)
  y <- cpp_unordered_map(c("a", "b", "c", "d"), 13:16)
  z <- cpp_unordered_map(c("c", "d", "e"), 11:13)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == string double", {
  x <- cpp_unordered_map(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  y <- cpp_unordered_map(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  z <- cpp_unordered_map(c("c", "d", "e"), seq.int(4.3, 4.7, 0.2))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == string string", {
  x <- cpp_unordered_map(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  y <- cpp_unordered_map(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  z <- cpp_unordered_map(c("c", "d", "e"), c("in", "this", "package"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == string boolean", {
  x <- cpp_unordered_map(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_unordered_map(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  z <- cpp_unordered_map(c("c", "d", "e"), c(FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == boolean integer", {
  x <- cpp_unordered_map(TRUE, 13L)
  y <- cpp_unordered_map(TRUE, 13L)
  z <- cpp_unordered_map(c(TRUE, FALSE), 11:12)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == boolean double", {
  x <- cpp_unordered_map(TRUE, 4)
  y <- cpp_unordered_map(TRUE, 4)
  z <- cpp_unordered_map(c(TRUE, FALSE), c(4.3, 4.7))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == boolean string", {
  x <- cpp_unordered_map(TRUE, "A")
  y <- cpp_unordered_map(TRUE, "A")
  z <- cpp_unordered_map(c(TRUE, FALSE), c("in", "this"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_map == boolean boolean", {
  x <- cpp_unordered_map(TRUE, TRUE)
  y <- cpp_unordered_map(TRUE, TRUE)
  z <- cpp_unordered_map(c(TRUE, FALSE), c(FALSE, TRUE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# multimap
testthat::test_that("multimap == integer integer", {
  x <- cpp_multimap(4:9, 12:17)
  y <- cpp_multimap(4:9, 12:17)
  z <- cpp_multimap(8:11, 11:14)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == integer double", {
  x <- cpp_multimap(4:9, seq.int(1, 3.5, 0.5))
  y <- cpp_multimap(4:9, seq.int(1, 3.5, 0.5))
  z <- cpp_multimap(8:11, seq.int(3, 4.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == integer string", {
  x <- cpp_multimap(6:9, c("hello", "there", "coding", "world"))
  y <- cpp_multimap(6:9, c("hello", "there", "coding", "world"))
  z <- cpp_multimap(8:11, c("a", "quick", "R", "test"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == integer boolean", {
  x <- cpp_multimap(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  y <- cpp_multimap(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  z <- cpp_multimap(8:11, c(TRUE, FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == double integer", {
  x <- cpp_multimap(seq.int(1, 2.5, 0.5), 13:16)
  y <- cpp_multimap(seq.int(1, 2.5, 0.5), 13:16)
  z <- cpp_multimap(seq.int(2, 3, 0.5), 11:13)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == double double", {
  x <- cpp_multimap(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  y <- cpp_multimap(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  z <- cpp_multimap(seq.int(2, 3, 0.5), seq.int(4.3, 4.7, 0.2))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == double string", {
  x <- cpp_multimap(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  y <- cpp_multimap(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  z <- cpp_multimap(seq.int(2, 3, 0.5), c("in", "this", "package"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == double boolean", {
  x <- cpp_multimap(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_multimap(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  z <- cpp_multimap(seq.int(2, 3, 0.5), c(FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == string integer", {
  x <- cpp_multimap(c("a", "b", "c", "d"), 13:16)
  y <- cpp_multimap(c("a", "b", "c", "d"), 13:16)
  z <- cpp_multimap(c("c", "d", "e"), 11:13)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == string double", {
  x <- cpp_multimap(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  y <- cpp_multimap(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  z <- cpp_multimap(c("c", "d", "e"), seq.int(4.3, 4.7, 0.2))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == string string", {
  x <- cpp_multimap(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  y <- cpp_multimap(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  z <- cpp_multimap(c("c", "d", "e"), c("in", "this", "package"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == string boolean", {
  x <- cpp_multimap(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_multimap(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  z <- cpp_multimap(c("c", "d", "e"), c(FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == boolean integer", {
  x <- cpp_multimap(TRUE, 13L)
  y <- cpp_multimap(TRUE, 13L)
  z <- cpp_multimap(c(TRUE, FALSE), 11:12)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == boolean double", {
  x <- cpp_multimap(TRUE, 4)
  y <- cpp_multimap(TRUE, 4)
  z <- cpp_multimap(c(TRUE, FALSE), c(4.3, 4.7))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == boolean string", {
  x <- cpp_multimap(TRUE, "A")
  y <- cpp_multimap(TRUE, "A")
  z <- cpp_multimap(c(TRUE, FALSE), c("in", "this"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("multimap == boolean boolean", {
  x <- cpp_multimap(TRUE, TRUE)
  y <- cpp_multimap(TRUE, TRUE)
  z <- cpp_multimap(c(TRUE, FALSE), c(FALSE, TRUE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# unordered_multimap
testthat::test_that("unordered_multimap == integer integer", {
  x <- cpp_unordered_multimap(4:9, 12:17)
  y <- cpp_unordered_multimap(4:9, 12:17)
  z <- cpp_unordered_multimap(8:11, 11:14)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == integer double", {
  x <- cpp_unordered_multimap(4:9, seq.int(1, 3.5, 0.5))
  y <- cpp_unordered_multimap(4:9, seq.int(1, 3.5, 0.5))
  z <- cpp_unordered_multimap(8:11, seq.int(3, 4.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == integer string", {
  x <- cpp_unordered_multimap(6:9, c("hello", "there", "coding", "world"))
  y <- cpp_unordered_multimap(6:9, c("hello", "there", "coding", "world"))
  z <- cpp_unordered_multimap(8:11, c("a", "quick", "R", "test"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == integer boolean", {
  x <- cpp_unordered_multimap(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  y <- cpp_unordered_multimap(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  z <- cpp_unordered_multimap(8:11, c(TRUE, FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == double integer", {
  x <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), 13:16)
  y <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), 13:16)
  z <- cpp_unordered_multimap(seq.int(2, 3, 0.5), 11:13)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == double double", {
  x <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  y <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  z <- cpp_unordered_multimap(seq.int(2, 3, 0.5), seq.int(4.3, 4.7, 0.2))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == double string", {
  x <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  y <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  z <- cpp_unordered_multimap(seq.int(2, 3, 0.5), c("in", "this", "package"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == double boolean", {
  x <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_unordered_multimap(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  z <- cpp_unordered_multimap(seq.int(2, 3, 0.5), c(FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == string integer", {
  x <- cpp_unordered_multimap(c("a", "b", "c", "d"), 13:16)
  y <- cpp_unordered_multimap(c("a", "b", "c", "d"), 13:16)
  z <- cpp_unordered_multimap(c("c", "d", "e"), 11:13)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == string double", {
  x <- cpp_unordered_multimap(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  y <- cpp_unordered_multimap(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  z <- cpp_unordered_multimap(c("c", "d", "e"), seq.int(4.3, 4.7, 0.2))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == string string", {
  x <- cpp_unordered_multimap(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  y <- cpp_unordered_multimap(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  z <- cpp_unordered_multimap(c("c", "d", "e"), c("in", "this", "package"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == string boolean", {
  x <- cpp_unordered_multimap(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  y <- cpp_unordered_multimap(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  z <- cpp_unordered_multimap(c("c", "d", "e"), c(FALSE, TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == boolean integer", {
  x <- cpp_unordered_multimap(TRUE, 13L)
  y <- cpp_unordered_multimap(TRUE, 13L)
  z <- cpp_unordered_multimap(c(TRUE, FALSE), 11:12)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == boolean double", {
  x <- cpp_unordered_multimap(TRUE, 4)
  y <- cpp_unordered_multimap(TRUE, 4)
  z <- cpp_unordered_multimap(c(TRUE, FALSE), c(4.3, 4.7))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == boolean string", {
  x <- cpp_unordered_multimap(TRUE, "A")
  y <- cpp_unordered_multimap(TRUE, "A")
  z <- cpp_unordered_multimap(c(TRUE, FALSE), c("in", "this"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("unordered_multimap == boolean boolean", {
  x <- cpp_unordered_multimap(TRUE, TRUE)
  y <- cpp_unordered_multimap(TRUE, TRUE)
  z <- cpp_unordered_multimap(c(TRUE, FALSE), c(FALSE, TRUE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# stack
testthat::test_that("stack == integer", {
  x <- cpp_stack(4:9)
  y <- cpp_stack(4:9)
  z <- cpp_stack(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("stack == double", {
  x <- cpp_stack(seq.int(1, 2, 0.5))
  y <- cpp_stack(seq.int(1, 2, 0.5))
  z <- cpp_stack(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("stack == string", {
  x <- cpp_stack(c("hello", "there"))
  y <- cpp_stack(c("hello", "there"))
  z <- cpp_stack(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("stack == boolean", {
  x <- cpp_stack(TRUE)
  y <- cpp_stack(TRUE)
  z <- cpp_stack(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# queue
testthat::test_that("queue == integer", {
  x <- cpp_queue(4:9)
  y <- cpp_queue(4:9)
  z <- cpp_queue(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("queue == double", {
  x <- cpp_queue(seq.int(1, 2, 0.5))
  y <- cpp_queue(seq.int(1, 2, 0.5))
  z <- cpp_queue(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("queue == string", {
  x <- cpp_queue(c("hello", "there"))
  y <- cpp_queue(c("hello", "there"))
  z <- cpp_queue(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("queue == boolean", {
  x <- cpp_queue(TRUE)
  y <- cpp_queue(TRUE)
  z <- cpp_queue(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# vector
testthat::test_that("vector == integer", {
  x <- cpp_vector(4:9)
  y <- cpp_vector(4:9)
  z <- cpp_vector(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("vector == double", {
  x <- cpp_vector(seq.int(1, 2, 0.5))
  y <- cpp_vector(seq.int(1, 2, 0.5))
  z <- cpp_vector(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("vector == string", {
  x <- cpp_vector(c("hello", "there"))
  y <- cpp_vector(c("hello", "there"))
  z <- cpp_vector(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("vector == boolean", {
  x <- cpp_vector(TRUE)
  y <- cpp_vector(TRUE)
  z <- cpp_vector(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# deque
testthat::test_that("deque == integer", {
  x <- cpp_deque(4:9)
  y <- cpp_deque(4:9)
  z <- cpp_deque(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("deque == double", {
  x <- cpp_deque(seq.int(1, 2, 0.5))
  y <- cpp_deque(seq.int(1, 2, 0.5))
  z <- cpp_deque(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("deque == string", {
  x <- cpp_deque(c("hello", "there"))
  y <- cpp_deque(c("hello", "there"))
  z <- cpp_deque(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("deque == boolean", {
  x <- cpp_deque(TRUE)
  y <- cpp_deque(TRUE)
  z <- cpp_deque(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# forward_list
testthat::test_that("forward_list == integer", {
  x <- cpp_forward_list(4:9)
  y <- cpp_forward_list(4:9)
  z <- cpp_forward_list(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("forward_list == double", {
  x <- cpp_forward_list(seq.int(1, 2, 0.5))
  y <- cpp_forward_list(seq.int(1, 2, 0.5))
  z <- cpp_forward_list(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("forward_list == string", {
  x <- cpp_forward_list(c("hello", "there"))
  y <- cpp_forward_list(c("hello", "there"))
  z <- cpp_forward_list(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("forward_list == boolean", {
  x <- cpp_forward_list(TRUE)
  y <- cpp_forward_list(TRUE)
  z <- cpp_forward_list(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# list
testthat::test_that("list == integer", {
  x <- cpp_list(4:9)
  y <- cpp_list(4:9)
  z <- cpp_list(4:10)
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("list == double", {
  x <- cpp_list(seq.int(1, 2, 0.5))
  y <- cpp_list(seq.int(1, 2, 0.5))
  z <- cpp_list(seq.int(1.5, 2.5, 0.5))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("list == string", {
  x <- cpp_list(c("hello", "there"))
  y <- cpp_list(c("hello", "there"))
  z <- cpp_list(c("there", "R", "world"))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})
testthat::test_that("list == boolean", {
  x <- cpp_list(TRUE)
  y <- cpp_list(TRUE)
  z <- cpp_list(c(TRUE, FALSE))
  testthat::expect_true(x == y)
  testthat::expect_false(x == z)
})

# map
testthat::test_that("map [ integer integer", {
  v <- cpp_map(4:9, 12:17)
  testthat::expect_equal(v[6L], 14L)
})
testthat::test_that("map [ integer double", {
  v <- cpp_map(4:9, seq.int(1, 3.5, 0.5))
  testthat::expect_equal(v[6L], 2)
})
testthat::test_that("map [ integer string", {
  v <- cpp_map(6:9, c("hello", "there", "coding", "world"))
  testthat::expect_equal(v[6L], "hello")
})
testthat::test_that("map [ integer boolean", {
  v <- cpp_map(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  testthat::expect_equal(v[6L], FALSE)
})
testthat::test_that("map [ double integer", {
  v <- cpp_map(seq.int(1, 2.5, 0.5), 13:16)
  testthat::expect_equal(v[1.5], 14L)
})
testthat::test_that("map [ double double", {
  v <- cpp_map(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  testthat::expect_equal(v[1.5], 4.1)
})
testthat::test_that("map [ double string", {
  v <- cpp_map(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  testthat::expect_equal(v[1.5], "quick")
})
testthat::test_that("map [ double boolean", {
  v <- cpp_map(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  testthat::expect_equal(v[1.5], FALSE)
})
testthat::test_that("map [ string integer", {
  v <- cpp_map(c("a", "b", "c", "d"), 13:16)
  testthat::expect_equal(v["b"], 14L)
})
testthat::test_that("map [ string double", {
  v <- cpp_map(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  testthat::expect_equal(v["b"], 4.1)
})
testthat::test_that("map [ string string", {
  v <- cpp_map(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  testthat::expect_equal(v["b"], "quick")
})
testthat::test_that("map [ string boolean", {
  v <- cpp_map(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  testthat::expect_equal(v["b"], FALSE)
})
testthat::test_that("map [ boolean integer", {
  v <- cpp_map(TRUE, 13L)
  testthat::expect_equal(v[TRUE], 13L)
})
testthat::test_that("map [ boolean double", {
  v <- cpp_map(TRUE, 4)
  testthat::expect_equal(v[TRUE], 4)
})
testthat::test_that("map [ boolean string", {
  v <- cpp_map(TRUE, "A")
  testthat::expect_equal(v[TRUE], "A")
})
testthat::test_that("map [ boolean boolean", {
  v <- cpp_map(TRUE, TRUE)
  testthat::expect_equal(v[TRUE], TRUE)
})

# unordered_map
testthat::test_that("unordered_map [ integer integer", {
  v <- cpp_unordered_map(4:9, 12:17)
  testthat::expect_equal(v[6L], 14L)
})
testthat::test_that("unordered_map [ integer double", {
  v <- cpp_unordered_map(4:9, seq.int(1, 3.5, 0.5))
  testthat::expect_equal(v[6L], 2)
})
testthat::test_that("unordered_map [ integer string", {
  v <- cpp_unordered_map(6:9, c("hello", "there", "coding", "world"))
  testthat::expect_equal(v[6L], "hello")
})
testthat::test_that("unordered_map [ integer boolean", {
  v <- cpp_unordered_map(4:9, c(TRUE, FALSE, FALSE, FALSE, TRUE, FALSE))
  testthat::expect_equal(v[6L], FALSE)
})
testthat::test_that("unordered_map [ double integer", {
  v <- cpp_unordered_map(seq.int(1, 2.5, 0.5), 13:16)
  testthat::expect_equal(v[1.5], 14L)
})
testthat::test_that("unordered_map [ double double", {
  v <- cpp_unordered_map(seq.int(1, 2.5, 0.5), seq.int(4, 4.3, 0.1))
  testthat::expect_equal(v[1.5], 4.1)
})
testthat::test_that("unordered_map [ double string", {
  v <- cpp_unordered_map(seq.int(1, 2.5, 0.5), c("A", "quick", "unit", "test"))
  testthat::expect_equal(v[1.5], "quick")
})
testthat::test_that("unordered_map [ double boolean", {
  v <- cpp_unordered_map(seq.int(1, 2.5, 0.5), c(TRUE, FALSE, FALSE, TRUE))
  testthat::expect_equal(v[1.5], FALSE)
})
testthat::test_that("unordered_map [ string integer", {
  v <- cpp_unordered_map(c("a", "b", "c", "d"), 13:16)
  testthat::expect_equal(v["b"], 14L)
})
testthat::test_that("unordered_map [ string double", {
  v <- cpp_unordered_map(c("a", "b", "c", "d"), seq.int(4, 4.3, 0.1))
  testthat::expect_equal(v["b"], 4.1)
})
testthat::test_that("unordered_map [ string string", {
  v <- cpp_unordered_map(c("a", "b", "c", "d"), c("A", "quick", "unit", "test"))
  testthat::expect_equal(v["b"], "quick")
})
testthat::test_that("unordered_map [ string boolean", {
  v <- cpp_unordered_map(c("a", "b", "c", "d"), c(TRUE, FALSE, FALSE, TRUE))
  testthat::expect_equal(v["b"], FALSE)
})
testthat::test_that("unordered_map [ boolean integer", {
  v <- cpp_unordered_map(TRUE, 13L)
  testthat::expect_equal(v[TRUE], 13L)
})
testthat::test_that("unordered_map [ boolean double", {
  v <- cpp_unordered_map(TRUE, 4)
  testthat::expect_equal(v[TRUE], 4)
})
testthat::test_that("unordered_map [ boolean string", {
  v <- cpp_unordered_map(TRUE, "A")
  testthat::expect_equal(v[TRUE], "A")
})
testthat::test_that("unordered_map [ boolean boolean", {
  v <- cpp_unordered_map(TRUE, TRUE)
  testthat::expect_equal(v[TRUE], TRUE)
})

# vector
testthat::test_that("vector [ integer", {
  v <- cpp_vector(4:9)
  testthat::expect_equal(v[3L], 6L)
})
testthat::test_that("vector [ double", {
  v <- cpp_vector(seq.int(1, 2.5, 0.5))
  testthat::expect_equal(v[3L], 2)
})
testthat::test_that("vector [ string", {
  v <- cpp_vector(c("hello", "there", "world"))
  testthat::expect_equal(v[3L], "world")
})
testthat::test_that("vector [ boolean", {
  v <- cpp_vector(c(TRUE, FALSE, FALSE))
  testthat::expect_equal(v[3L], FALSE)
})

# deque
testthat::test_that("deque [ integer", {
  v <- cpp_deque(4:9)
  testthat::expect_equal(v[3L], 6L)
})
testthat::test_that("deque [ double", {
  v <- cpp_deque(seq.int(1, 2.5, 0.5))
  testthat::expect_equal(v[3L], 2)
})
testthat::test_that("deque [ string", {
  v <- cpp_deque(c("hello", "there", "world"))
  testthat::expect_equal(v[3L], "world")
})
testthat::test_that("deque [ boolean", {
  v <- cpp_deque(c(TRUE, FALSE, FALSE))
  testthat::expect_equal(v[3L], FALSE)
})
