% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-class.R
\docType{class}
\name{DualResponsesSamplesDesign-class}
\alias{DualResponsesSamplesDesign-class}
\alias{.DualResponsesSamplesDesign}
\alias{DualResponsesSamplesDesign}
\alias{.DefaultDualResponsesSamplesDesign}
\title{\code{DualResponsesSamplesDesign}}
\usage{
DualResponsesSamplesDesign(eff_model, data, ...)

.DefaultDualResponsesSamplesDesign()
}
\arguments{
\item{eff_model}{(\code{ModelEff})\cr see slot definition.}

\item{data}{(\code{DataDual})\cr see slot definition.}

\item{...}{
  Arguments passed on to \code{\link[=TDsamplesDesign]{TDsamplesDesign}}
  \describe{
    \item{\code{model}}{(\code{ModelTox})\cr see slot definition.}
    \item{\code{stopping}}{(\code{Stopping})\cr see slot definition.}
    \item{\code{increments}}{(\code{Increments})\cr see slot definition.}
    \item{\code{pl_cohort_size}}{(\code{CohortSize})\cr see slot definition.}
  }}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is a class of design based on DLE responses using the \code{\link{LogisticIndepBeta}} model
with DLE and efficacy samples. It contain all slots in
\code{\link{RuleDesign}} and \code{\link{TDsamplesDesign}} class objects.
}
\section{Slots}{

\describe{
\item{\code{data}}{(\code{DataDual})\cr the data set.}

\item{\code{eff_model}}{(\code{ModelEff})\cr the pseudo efficacy model to be used.}
}}

\note{
Typically, end users will not use the \code{.DefaultDualResponsesSamplesDesign()} function.
}
\examples{
empty_data <- DataDual(doseGrid = seq(25, 300, 25))

tox_model <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEweights = c(3, 3),
  DLEdose = c(25, 300),
  data = empty_data
)
options <- McmcOptions(burnin = 100, step = 2, samples = 200)
tox_samples <- mcmc(empty_data, tox_model, options)

eff_model <- Effloglog(
  eff = c(1.223, 2.513),
  eff_dose = c(25, 300),
  nu = c(a = 1, b = 0.025),
  data = empty_data
)
eff_samples <- mcmc(empty_data, eff_model, options)

my_next_best <- NextBestMaxGainSamples(
  prob_target_drt = 0.35,
  prob_target_eot = 0.3,
  derive = function(samples) {
    as.numeric(quantile(samples, prob = 0.3))
  },
  mg_derive = function(mg_samples) {
    as.numeric(quantile(mg_samples, prob = 0.5))
  }
)

my_increments <- IncrementsRelative(
  intervals = c(25, 300),
  increments = c(2, 2)
)
my_size <- CohortSizeConst(size = 3)
my_stopping <- StoppingMinPatients(nPatients = 36)

design <- DualResponsesSamplesDesign(
  nextBest = my_next_best,
  cohort_size = my_size,
  startingDose = 25,
  model = tox_model,
  eff_model = eff_model,
  data = empty_data,
  stopping = my_stopping,
  increments = my_increments
)
}
