% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-methods.R
\name{ngrid}
\alias{ngrid}
\alias{ngrid,Data-method}
\alias{ngrid-Data}
\title{Number of Doses in Grid}
\usage{
ngrid(object, ignore_placebo = TRUE, ...)

\S4method{ngrid}{Data}(object, ignore_placebo = TRUE, ...)
}
\arguments{
\item{object}{(\code{Data})\cr object with dose grid.}

\item{ignore_placebo}{(\code{flag})\cr should placebo dose (if any) not be counted?}

\item{...}{further arguments passed to class-specific methods.}
}
\value{
\code{integer} the number of doses in grid.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function that gets the number of doses in grid. User can choose whether
the placebo dose (if any) should be counted or not.
}
\examples{
my_data <- Data(
  x = c(10, 50, 90, 100, 0.001, 20, 30, 30),
  y = c(0, 0, 0, 0, 0, 0, 1, 0),
  ID = 1:8,
  cohort = c(1L, 2L, 3L, 4L, 5L, 5L, 6L, 6L),
  doseGrid = c(0.001, seq(from = 10, to = 100, by = 10)),
  placebo = TRUE
)
ngrid(my_data)
ngrid(my_data, ignore_placebo = FALSE)
}
