% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_pwr_pval_adj.R
\name{calc_K_pval_adj}
\alias{calc_K_pval_adj}
\title{Calculate required number of clusters per treatment group for a cluster-randomized trial with co-primary endpoints using three common p-value adjustment methods}
\usage{
calc_K_pval_adj(
  dist = "Chi2",
  power,
  m,
  alpha = 0.05,
  beta1,
  beta2,
  varY1,
  varY2,
  rho01,
  rho02,
  rho2,
  r = 1
)
}
\arguments{
\item{dist}{Specification of which distribution to base calculation on, either 'Chi2' for Chi-Squared or 'F' for F-Distribution.}

\item{power}{Desired statistical power in decimal form; numeric.}

\item{m}{Individuals per cluster; numeric.}

\item{alpha}{Type I error rate; numeric.}

\item{beta1}{Effect size for the first outcome; numeric.}

\item{beta2}{Effect size for the second outcome; numeric.}

\item{varY1}{Total variance for the first outcome; numeric.}

\item{varY2}{Total variance for the second outcome; numeric.}

\item{rho01}{Correlation of the first outcome for two different individuals in the same cluster; numeric.}

\item{rho02}{Correlation of the second outcome for two different individuals in the same cluster; numeric.}

\item{rho2}{Correlation between the first and second outcomes for the same individual; numeric.}

\item{r}{Treatment allocation ratio - K2 = rK1 where K1 is number of clusters in experimental group; numeric.}
}
\value{
A data frame of numerical values.
}
\description{
Allows user to calculate the number of clusters per treatment arm of a cluster-randomized trial with two co-primary endpoints given a set of study design input values, including the statistical power, and cluster size. Uses three common p-value adjustment methods.
}
\examples{
calc_K_pval_adj(power = 0.8, m = 300, alpha = 0.05,
beta1 = 0.1, beta2 = 0.1, varY1 = 0.23, varY2 = 0.25,
rho01 = 0.025, rho02 = 0.025, rho2  = 0.05)
}
