% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs.R
\name{get_exposure_list_presence_tags_by_dtxsid}
\alias{get_exposure_list_presence_tags_by_dtxsid}
\title{Retrieve document data and list presence tags for a chemical}
\usage{
get_exposure_list_presence_tags_by_dtxsid(
  DTXSID = NULL,
  API_key = NULL,
  Server = exposure_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame of document information and list presence tags
}
\description{
Retrieve document data and list presence tags for a chemical
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull list presence tags for BPA
bpa <- get_exposure_list_presence_tags(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
