% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_joint_circ}
\alias{plot_joint_circ}
\title{Circular Scatterplot of Turn Angles and Step Lengths}
\usage{
plot_joint_circ(traj = NULL, theta = NULL, x = NULL)
}
\arguments{
\item{traj}{\link[base]{data.frame} containing the trajectory produced by e.g.
\code{\link{traj_sim}()}. It must contain
 the columns \code{traj$angle} and \code{traj$steplength}.}

\item{theta}{(alternatively) \link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable) or "circular" component of pseudo-observations.}

\item{x}{(alternatively) \link[base]{numeric} \link[base]{vector} of step lengths
(measurements of a linear variable) or "linear" component of pseudo-observations.}
}
\value{
A '\code{\link[ggplot2]{ggplot}}' object.
}
\description{
This function produces a circular scatterplot with the step lengths plotted
as distance from the center of a circle and the turn angles as angles
(polar coordinates).
}
\details{
You can either specify \code{traj} or the angels and step lengths
\code{theta} and \code{x}.
}
\examples{
set.seed(123)

traj <- traj_sim(100,
  copula = cyl_quadsec(0.1),
  marginal_circ = list(name="vonmises",coef=list(0, 1)),
  marginal_lin = list(name="weibull", coef=list(shape=3))
)
plot1 <- plot_joint_circ(traj)

}
\references{
\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{plot_cop_scat}()}, \code{\link{plot_track}()},
\code{\link{plot_cop_surf}()}, \code{\link{plot_joint_scat}()}.
}
