% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skcla_rf.R
\name{skcla_rf}
\alias{skcla_rf}
\title{Random Forest Classifier}
\usage{
skcla_rf(
  attribute,
  slevels,
  n_estimators = 100,
  criterion = "gini",
  max_depth = NULL,
  min_samples_split = 2,
  min_samples_leaf = 1,
  min_weight_fraction_leaf = 0,
  max_features = "sqrt",
  max_leaf_nodes = NULL,
  min_impurity_decrease = 0,
  bootstrap = TRUE,
  oob_score = FALSE,
  n_jobs = NULL,
  random_state = NULL,
  verbose = 0,
  warm_start = FALSE,
  class_weight = NULL,
  ccp_alpha = 0,
  max_samples = NULL,
  monotonic_cst = NULL
)
}
\arguments{
\item{attribute}{Target attribute name for model building}

\item{slevels}{List of possible values for classification target}

\item{n_estimators}{Number of trees in random forest}

\item{criterion}{Function name for measuring split quality}

\item{max_depth}{Maximum tree depth value}

\item{min_samples_split}{Minimum samples needed for internal node split}

\item{min_samples_leaf}{Minimum samples needed at leaf node}

\item{min_weight_fraction_leaf}{Minimum weighted fraction value}

\item{max_features}{Number of features to consider for best split}

\item{max_leaf_nodes}{Maximum number of leaf nodes}

\item{min_impurity_decrease}{Minimum impurity decrease needed for split}

\item{bootstrap}{Whether to use bootstrap samples}

\item{oob_score}{Whether to use out-of-bag samples}

\item{n_jobs}{Number of parallel jobs}

\item{random_state}{Seed for random number generation}

\item{verbose}{Whether to enable verbose output}

\item{warm_start}{Whether to reuse previous solution}

\item{class_weight}{Weights associated with classes}

\item{ccp_alpha}{Complexity parameter value for pruning}

\item{max_samples}{Number of samples for training estimators}

\item{monotonic_cst}{Monotonicity constraints for features}
}
\value{
A Random Forest classifier object

\code{skcla_rf} object
}
\description{
Implements classification using Random Forest algorithm.
This function wraps the RandomForestClassifier from Python's scikit-learn library.
}
\details{
Tree Ensemble
}
\examples{
#See an example of using `skcla_rf` at this
#https://github.com/cefet-rj-dal/daltoolboxdp/blob/main/examples/skcla_rf.md
}
