% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_cloud.R
\name{word_cloud}
\alias{word_cloud}
\title{Funcion de nube de palabras}
\usage{
word_cloud(datos, max_words, stop_words = NULL)
}
\arguments{
\item{datos}{data frame que incluye la columna contenido_limpio.}

\item{max_words}{Cantidad maxima de palabras que apareceran en la nube.}

\item{stop_words}{Definir las palabras que seran ignoradas en la visualizacion. Debe ser un vector de carácteres.}
}
\value{
Una nube de palabras con las palabras mas frecuentes.
}
\description{
Esta funcion permite realizar una nube de palabras con las palabras más frecuentes del corpus de noticias.
}
\examples{
\dontrun{
datos <- extraer_noticias_fecha("Boric",
"2025-03-01",
"2025-04-01",
fuentes="bbcl",
subir_a_bd = FALSE)
datos_proc <- limpieza_notas(datos)
word_cloud(datos_proc, max_words = 50, stop_words = c("es", "la"))
}
}
