% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeDataDatana.r
\docType{data}
\name{ficdiamgr}
\alias{ficdiamgr}
\title{Diameter growth of trees}
\format{
A time series data containing the following columns:
\describe{
\item{tree.id}{an ordered factor indicating the tree on which the 
measurement is made. The ordering is according to increasing maximum 
diameter.}
\item{time}{a numeric vector giving the numbers of days since 
establishment.}
\item{dbh}{a numeric vector of diameter at breast height, in cm.}
\item{site}{a factor variable, representing site conditions with two 
levels.}
\item{spp}{a factor variable, representing tree species with three levels.}
 }
}
\source{
This dataframe was built from the 'Orange' data of the \eqn{datasets} package,
 by Christian Salas-Eljatib.
}
\usage{
data(ficdiamgr)
}
\description{
The 'ficdiamgr' is a fictitious dataframe built to show the structure of 
 longitudinal data. The dataframe has records of tree diameter growth of 
 five sample trees, spanning three species.
}
\examples{
data(ficdiamgr)

coplot(dbh ~ time | tree, data = ficdiamgr, show.given = FALSE)
}
\keyword{datasets}
