% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwc_terms.R
\name{dwc_terms}
\alias{dwc_terms}
\title{Print Darwin Core Terms, Definitions and Examples as Bullet Lists}
\usage{
dwc_terms(dwc, terms)
}
\arguments{
\item{dwc}{a list of standard terms and definitions created using \link{get_dwc}.}

\item{terms}{a vector or list of terms to check.}
}
\value{
a bullet list.
}
\description{
\code{dwc_terms()} checks a vector or list of terms and return definitions and examples for
each one of them.
}
\details{
For each term in a vector or list, \code{dwc_terms} will return a bullet list containing
the term, followed by its definition and examples.
}
\examples{
dwc <- get_dwc(type= "simple")
dwc_terms(dwc, c("genus", "scientificName"))

}
\author{
Pedro S. Bittencourt, Rupert A. Collins.
}
