% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{height}
\alias{height}
\title{Height of Tree or any vertical Object}
\usage{
height(
  distance,
  top,
  bottom,
  type = c("angle", "slope"),
  angleUnit = c("deg", "rad")
)
}
\arguments{
\item{distance}{numeric, vector of the horizontal distance between object
and the person who measures angle.}

\item{top, bottom}{numeric vector of top angle and bottom angle respectively
(readings from a clinometer).}

\item{type}{the type of \code{top} and \code{bottom} measures. Either
\code{"angle"} or \code{"slope"}. Default is \code{"slope"}.}

\item{angleUnit}{the unit of \code{top} and \code{bottom} measures when
\code{type = "angle"}. Either \code{"deg"} for degree or \code{"rad"} for
radian. Default is \code{"deg"}.}
}
\value{
A vector of heights.
}
\description{
Computes the height of tree, pillar, girder, mast or any
vertical object. It allows either slope (in percent) or angle (in degrees or
radians). No matter the relative position of the persons who measures the
angle or the slope.
}
\examples{
height(10, 80, 17)
height(17, top = -18, bottom = -113)
height(distance = 18, top = 42, bottom = -12, type = "angle", angleUnit = "deg")
height(
  distance = 18:21, top = 42:45, bottom = -12:-15, type = "angle",
  angleUnit = "deg"
)
## Below shows warning messages
height(
  distance = 18:21, top = -42:-45, bottom = -12:-15, type = "angle",
  angleUnit = "deg"
)
}
