% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopulaCoxPHmodel_BootstrapMethods.R
\name{boot.fun}
\alias{boot.fun}
\title{Nonparametric bootstrap approach for the dependent censoring model}
\usage{
boot.fun(
  init,
  resData,
  X,
  W,
  lhat,
  cumL,
  dist,
  k,
  lb,
  ub,
  Obs.time,
  cop,
  n.boot,
  n.iter,
  ncore,
  eps
)
}
\arguments{
\item{init}{Initial values for the finite dimensional parameters obtained from the fit of \code{\link{fitDepCens}}}

\item{resData}{Data matrix with three columns;  Z = the observed survival time, d1 = the censoring indicator of T
and  d2 =  the censoring indicator of C.}

\item{X}{Data matrix with covariates related to T}

\item{W}{Data matrix with covariates related to C. First column of W should be a vector of ones}

\item{lhat}{Initial values for the hazard function obtained from the fit of \code{\link{fitDepCens}} based on the original data.}

\item{cumL}{Initial values for the cumulative hazard function obtained from the fit of \code{\link{fitDepCens}} based on the original data.}

\item{dist}{The distribution to be used for the  dependent censoring time C. Only two distributions are allowed, i.e, Weibull
and lognormal distributions. With the value \code{"Weibull"} as the
  default.}

\item{k}{Dimension of X}

\item{lb}{lower boundary for finite dimensional parameters}

\item{ub}{Upper boundary for finite dimensional parameters}

\item{Obs.time}{Observed survival time, which is the minimum of T, C and A, where A is the administrative censoring time.}

\item{cop}{Which copula should be computed to account for dependency between T and C. This argument can take
one of the values from \code{c("Gumbel", "Frank", "Normal")}.}

\item{n.boot}{Number of bootstraps to use in the estimation of bootstrap standard errors.}

\item{n.iter}{Number of iterations; the default is \code{n.iter = 20}. The larger the number of iterations, the longer the computational time.}

\item{ncore}{The number of cores to use for parallel computation is configurable, with the default \code{ncore = 7}.}

\item{eps}{Convergence error. This is set by the user in such away that the desired convergence is met; the default is \code{eps = 1e-3}}
}
\value{
Bootstrap standard errors for parameter estimates and for estimated cumulative hazard function.
}
\description{
This function estimates the bootstrap standard errors for the finite-dimensional model parameters and for the non-parametric cumulative
hazard function. Parallel computing using foreach has been used to speed up the estimation of standard errors.
}
