qlr.cv = function(tAll, from = round(0.15*tAll), to = round(0.85*tAll), L = 2, sig.level = list(0.05, 0.01, 0.1)){

sig.level = match.arg(NULL, sig.level)

lambda = round(to/tAll*(1-from/tAll)/(from/tAll*(1-to/tAll)),4)
range = c(from,to)
names(range) = c("t0", "t1")

ASY = array(c(
matrix(c(
  6.63,9.23,11.35,13.37,15.05,16.80,18.52,19.94,21.49,23.02,24.55,25.92,27.36,29.07,30.47,31.88,33.19,34.51,35.89,37.22,
  7.63,10.35,12.77,14.75,16.61,18.44,20.18,21.70,23.29,24.90,26.48,27.93,29.46,31.14,32.57,33.96,35.46,36.78,38.15,39.51,
  8.07,10.90,13.31,15.37,17.26,19.16,20.92,22.49,24.09,25.63,27.23,28.72,30.26,31.92,33.35,34.91,36.25,37.71,39.11,40.58,
  8.44,11.27,13.67,15.88,17.75,19.65,21.48,23.02,24.67,26.14,27.84,29.33,31.04,32.57,34.07,35.59,36.95,38.40,39.83,41.31,
  8.93,11.89,14.31,16.57,18.49,20.42,22.19,23.78,25.47,27.06,28.76,30.39,32.07,33.57,35.12,36.61,37.91,39.15,40.91,42.46,
  9.81,12.91,15.39,17.61,19.63,21.56,23.44,25.10,26.83,28.43,30.28,31.82,33.41,35.14,36.88,38.29,39.67,41.18,42.67,44.11,
  10.40,13.58,16.13,18.42,20.53,22.39,24.21,26.02,27.72,29.43,31.24,32.87,34.43,36.31,37.87,39.37,40.82,42.32,43.75,45.26,
  10.84,14.10,16.65,18.96,21.12,22.96,24.90,26.77,28.47,30.14,31.99,33.62,35.24,37.16,38.69,40.19,41.62,43.22,44.73,46.21,
  11.28,14.61,17.13,19.47,21.71,23.60,25.58,27.36,29.13,30.79,32.71,34.33,35.96,37.80,39.30,40.87,42.38,44.02,45.56,47.05,
  11.71,15.09,17.65,19.96,22.21,24.16,26.21,28.03,29.76,31.54,33.33,34.97,36.71,38.42,40.02,41.54,43.13,44.79,46.36,47.81,
  12.16,15.56,18.07,20.47,22.66,24.74,26.72,28.55,30.42,32.31,33.96,35.67,37.29,38.96,40.68,42.27,43.90,45.50,47.03,48.59,
  12.59,16.09,18.59,20.97,23.21,25.30,27.26,29.16,31.03,32.96,34.62,36.39,37.98,39.76,41.45,43.12,44.68,46.24,47.81,49.48,
  13.17,16.57,19.28,21.63,23.85,25.98,27.94,29.89,31.85,33.58,35.36,37.12,38.78,40.65,42.34,43.98,45.53,47.06,48.78,50.47),
nrow=13,ncol=20,byrow=T
),
matrix(c(
  3.79,5.97,7.82,9.51,11.07,12.62,14.06,15.47,16.84,18.29,19.62,20.96,22.29,23.55,24.89,26.21,27.50,28.80,30.07,31.39,
  4.60,6.99,8.93,10.75,12.38,14.03,15.56,16.98,18.49,19.92,21.40,22.76,24.14,25.52,26.89,28.21,29.60,30.91,32.25,33.55,
  4.96,7.41,9.43,11.27,12.95,14.61,16.17,17.66,19.19,20.69,22.13,23.54,24.94,26.32,27.71,29.07,30.47,31.82,33.14,34.52,
  5.24,7.75,9.81,11.67,13.41,15.07,16.67,18.16,19.72,21.23,22.71,24.11,25.55,26.95,28.38,29.72,31.10,32.43,33.81,35.20,
  5.65,8.25,10.37,12.30,14.04,15.77,17.36,18.94,20.52,22.00,23.58,24.98,26.47,27.84,29.28,30.62,32.11,33.49,34.83,36.22,
  6.40,9.13,11.35,13.37,15.19,16.93,18.63,20.26,21.88,23.40,24.96,26.46,27.97,29.44,30.86,32.30,33.78,35.20,36.63,38.05,
  6.97,9.80,12.08,14.16,16.02,17.81,19.54,21.15,22.79,24.35,26.00,27.52,29.00,30.57,32.00,33.45,34.94,36.38,37.80,39.21,
  7.47,10.34,12.65,14.73,16.65,18.50,20.26,21.89,23.57,25.15,26.79,28.36,29.87,31.39,32.90,34.34,35.81,37.31,38.72,40.18,
  7.87,10.78,13.18,15.29,17.27,19.12,20.91,22.60,24.28,25.88,27.52,29.06,30.64,32.15,33.68,35.15,36.63,38.15,39.60,41.06,
  8.28,11.26,13.66,15.84,17.78,19.66,21.48,23.21,24.93,26.49,28.13,29.75,31.36,32.88,34.37,35.92,37.42,38.91,40.37,41.85,
  8.68,11.72,14.13,16.36,18.32,20.24,22.06,23.82,25.54,27.13,28.81,30.43,32.04,33.56,35.10,36.64,38.21,39.65,41.14,42.68,
  9.11,12.17,14.69,16.91,18.86,20.81,22.62,24.45,26.16,27.77,29.51,31.12,32.76,34.31,35.86,37.43,39.00,40.45,41.90,43.47,
  9.71,12.80,15.36,17.54,19.57,21.53,23.41,25.20,26.95,28.64,30.33,31.95,33.63,35.16,36.77,38.35,39.94,41.46,42.96,44.46),
nrow=13,ncol=20,byrow=T
),
matrix(c(
  2.69,4.61,6.25,7.77,9.23,10.65,12.02,13.31,14.65,15.99,17.24,18.52,19.76,20.98,22.24,23.48,24.72,25.92,27.12,28.34,
  3.39,5.48,7.29,8.90,10.45,11.96,13.42,14.78,16.17,17.59,18.91,20.24,21.55,22.83,24.13,25.40,26.72,27.98,29.22,30.47,
  3.70,5.87,7.75,9.40,11.01,12.53,14.02,15.42,16.84,18.26,19.61,20.99,22.31,23.60,24.94,26.25,27.59,28.86,30.09,31.38,
  3.93,6.19,8.08,9.80,11.42,12.97,14.47,15.90,17.34,18.79,20.18,21.55,22.87,24.20,25.55,26.86,28.25,29.51,30.77,32.09,
  4.30,6.66,8.62,10.41,12.04,13.62,15.16,16.67,18.10,19.57,21.02,22.38,23.77,25.14,26.50,27.82,29.20,30.52,31.84,33.16,
  4.99,7.47,9.54,11.38,13.17,14.81,16.41,17.94,19.45,20.97,22.42,23.85,25.27,26.68,28.09,29.43,30.84,32.23,33.58,34.90,
  5.49,8.10,10.25,12.15,13.94,15.67,17.25,18.86,20.43,21.93,23.43,24.90,26.38,27.78,29.22,30.60,32.00,33.43,34.78,36.15,
  5.93,8.62,10.82,12.76,14.60,16.34,17.99,19.60,21.19,22.74,24.23,25.76,27.23,28.69,30.12,31.52,32.94,34.39,35.78,37.18,
  6.35,9.09,11.32,13.33,15.21,16.97,18.66,20.30,21.90,23.45,24.97,26.48,27.98,29.50,30.93,32.36,33.78,35.26,36.70,38.08,
  6.73,9.54,11.81,13.82,15.76,17.52,19.25,20.91,22.55,24.14,25.68,27.22,28.72,30.26,31.71,33.16,34.58,36.07,37.48,38.89,
  7.12,10.00,12.28,14.34,16.30,18.11,19.87,21.55,23.20,24.80,26.38,27.90,29.45,30.98,32.47,33.92,35.39,36.87,38.27,39.72,
  7.58,10.46,12.81,14.92,16.87,18.71,20.49,22.20,23.89,25.47,27.05,28.63,30.17,31.71,33.22,34.71,36.21,37.68,39.12,40.55,
  8.13,11.08,13.46,15.64,17.58,19.45,21.28,23.02,24.71,26.33,27.92,29.55,31.11,32.66,34.15,35.68,37.23,38.69,40.16,41.65),
nrow=13,ncol=20,byrow=T
)
),c(13,20,3),
dimnames = list(
  c(1.00,1.08,1.17,1.27,1.49,2.25,3.45,5.44,9.00,16.00,32.11,81.00,361.00),
  1:20,
  c(0.01,0.05,0.1)
  )
)
cv.chi2 = ASY[,as.character(L), as.character(sig.level)]
x = as.numeric(names(cv.chi2))
names(cv.chi2) = NULL
cv.chi2 = data.frame(lambda = x, CritVal = cv.chi2)
idx = dim(cv.chi2[cv.chi2$lambda <= lambda,])[1]
cv.chi2 = cv.chi2[c(idx,idx+1),]
row.names(cv.chi2) = c("lower", "upper")
cv.f = cv.chi2
cv.f[,2] = cv.f[,2]/L
return(list(lambda = lambda, range = range, cv.chi2 = cv.chi2, cv.f = cv.f))
}
