% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synoptique.R
\name{create_list_synoptique}
\alias{create_list_synoptique}
\title{Create a List of Synoptic Plots Based on Different Options}
\usage{
create_list_synoptique(tree, options, depth = NA)
}
\arguments{
\item{tree}{\code{Tree structure object} representing the decision tree.}

\item{options}{\code{matrix} where each column denotes a distinct set of
options for evaluating the decision tree.}

\item{depth}{Optional \code{numeric} specifying the depth of the tree. If
provided, a sub-tree is produced up to the specified depth. By default, it
is set to NA.}
}
\value{
A \code{list} of \code{ggplot} objects. Each item in the list is a
synoptic plot corresponding to a column from the 'options' matrix.
}
\description{
Produces a list of synoptic plots, one for each set of options specified in
the columns of the 'options' matrix. Each plot visualizes nodes of a decision
tree based on different evaluation options.
}
\examples{
tree <- dexisensitivity::masc2
options <- create_options(tree, num_options=3, seed = 42)
create_list_synoptique(tree, options)

}
\seealso{
\code{\link{create_synoptique}}
}
