% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothPolarizedGenotypes.r
\name{smoothPolarizedGenotypes}
\alias{smoothPolarizedGenotypes}
\title{Smooths Polarized Genotype States}
\usage{
smoothPolarizedGenotypes(
  genotypes,
  includedSites,
  ChosenSites = "all",
  windows = NULL,
  windowSize = NULL,
  ...
)
}
\arguments{
\item{genotypes}{A character matrix comprising of _012 encodings.}

\item{includedSites}{A character path to a file with columns \code{CHROM} and \code{POS}.}

\item{ChosenSites}{A logical vector indicating which sites are to be included in the
analysis.}

\item{windows}{A two-column numeric matrix with indices of start and end positions for
windows for all markers indicated by \code{ChosenSites}.}

\item{windowSize}{A numeric window size for metric conversion in base-pairs.}

\item{...}{Additional parameters to be passed to \link{rank2map} if \code{windows = NULL}.}
}
\description{
This function smooths polarized genotype states using a Laplace kernel density estimation.
It calculates a smoothed version of the genotype states over specified windows.
}
\details{
Ensure that \code{ChosenSites} is the same as was used to import polarized genotypes.

The function uses a Laplace kernel to weight the genotype states within a window around each marker position,
based on physical positions of the markers. The smoothing process accounts for chromosome-level scales.

The Laplace kernel density is calculated as:
\deqn{\frac{1}{2b} \exp\left(\frac{-|x - \mu|}{b}\right)}
where \eqn{x} is the position, \eqn{\mu} is the center of the kernel, and \eqn{b} is the scale parameter.
The scale parameter is \eqn{b = 10^{-4} n}, where \eqn{n} is the position of the last
marker on the chromosome.
}
\examples{
 \dontrun{
 # Run this example in a working directory with write permissions
 myo <- system.file("extdata", "myotis.vcf", package = "diemr")
 vcf2diem(myo, "myo")
 fit <- diem("myo-001.txt", ChosenInds = 1:14)
 gen <- importPolarized("myo-001.txt", changePolarity = fit$markerPolarity, ChosenInds = 1:14)
 h <- apply(gen, 1, \(x) pHetErrOnStateCount(sStateCount(x)))[1, ]
 gen2 <- smoothPolarizedGenotypes(genotypes = gen, 
    includedSites = "myo-includedSites.txt", windowSize = 50)
 plotPolarized(gen, h)
 plotPolarized(gen2, h)
 }
}
