% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffr.R
\name{diffr}
\alias{diffr}
\title{Diff 2 files side by side}
\usage{
diffr(file1, file2, contextSize = 3, minJumpSize = 10, wordWrap = TRUE,
  before = file1, after = file2, width = NULL, height = NULL)
}
\arguments{
\item{file1}{First file to take diff (usually original file)}

\item{file2}{First file to take diff (usually updated file)}

\item{contextSize}{Minimum number of lines of context to
show around each diff hunk. (default: 3).}

\item{minJumpSize}{Minimum number of equal lines to collapse
into a ``Show N more lines'' link. (default: 10)}

\item{wordWrap}{By default, code will go all the way to the
right margin of the diff. If there are 60 characters of space,
character 61 will wrap to the next line, even mid-word.
To wrap at word boundaries instead, set this option.}

\item{before}{Text to display on file1}

\item{after}{Text to display on file2}

\item{width}{passed to \code{\link{createWidget}}}

\item{height}{passed to \code{\link{createWidget}}}
}
\description{
Takes the diff of 2 files and shows comparisons
}
\examples{
library(diffr)
file1 = tempfile()
writeLines("hello, world!\\n", con = file1)
file2 = tempfile()
writeLines(paste0(
"hello world?\\nI don't get it\\n",
paste0(sample(letters, 65, replace = TRUE), collapse = "")), con = file2)
diffr(file1, file2, before = "f1", after = "f2")
}
