% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZTPoisson.R
\name{ZTPoisson}
\alias{ZTPoisson}
\title{Create a zero-truncated Poisson distribution}
\usage{
ZTPoisson(lambda)
}
\arguments{
\item{lambda}{Parameter of the underlying untruncated Poisson distribution.
Can be any positive number.}
}
\value{
A \code{ZTPoisson} object.
}
\description{
Zero-truncated Poisson distributions are frequently used to model counts
where zero observations cannot occur or have been excluded.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail.

In the following, let \eqn{X} be a zero-truncated Poisson random variable with parameter
\code{lambda} = \eqn{\lambda}.

\strong{Support}: \eqn{\{1, 2, 3, ...\}}{{1, 2, 3, ...}}

\strong{Mean}:
\deqn{
    \lambda \cdot \frac{1}{1 - e^{-\lambda}}
  }{
    \lambda \cdot 1/(1 - e^{-\lambda})
  }

\strong{Variance}: \eqn{m \cdot (\lambda + 1 - m)}, where \eqn{m} is the mean above.

\strong{Probability mass function (p.m.f.)}:

\deqn{
    P(X = k) = \frac{f(k; \lambda)}{1 - f(0; \lambda)}
  }{
    P(X = k) = f(k; \lambda)/(1 - f(0; \lambda))
  }

where \eqn{f(k; \lambda)} is the p.m.f. of the \code{\link{Poisson}}
distribution.

\strong{Cumulative distribution function (c.d.f.)}:

\deqn{
    P(X = k) = \frac{F(k; \lambda)}{1 - F(0; \lambda)}
  }{
    P(X = k) = F(k; \lambda)/(1 - F(0; \lambda))
  }

where \eqn{F(k; \lambda)} is the c.d.f. of the \code{\link{Poisson}} distribution.

\strong{Moment generating function (m.g.f.)}:

\deqn{
    E(e^{tX}) = \frac{1}{1 - e^{-\lambda}} \cdot e^{\lambda (e^t - 1)}
  }{
    E(e^(tX)) = 1/(1 - e^{-\lambda}) \cdot e^(\lambda (e^t - 1))
  }
}
\examples{
## set up a zero-truncated Poisson distribution
X <- ZTPoisson(lambda = 2.5)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.25))

## cdf() and quantile() are inverses for each other
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HurdleNegativeBinomial}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{PoissonBinomial}()},
\code{\link{ZINegativeBinomial}()},
\code{\link{ZIPoisson}()},
\code{\link{ZTNegativeBinomial}()}
}
\concept{discrete distributions}
