% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{plot_correlate.data.frame}
\alias{plot_correlate.data.frame}
\title{Visualize correlation plot of numerical data}
\usage{
\method{plot_correlate}{data.frame}(
  .data,
  ...,
  method = c("pearson", "kendall", "spearman"),
  typographic = TRUE,
  base_family = NULL
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_correlate() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.

See vignette("EDA") for an introduction to these concepts.}

\item{method}{a character string indicating which correlation coefficient (or covariance) is 
to be computed. One of "pearson" (default), "kendall", or "spearman": can be abbreviated.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\value{
a ggplot2 object.
}
\description{
The plot_correlate() visualize correlation plot
for find relationship between two numerical variables.
}
\details{
The scope of the visualization is the provide a correlation information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.

The direction of the diagonal is top-left to bottom-right. and color of the 
cells is 'red' to -1, 'blue' to 1.

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\seealso{
\code{\link{plot_correlate.tbl_dbi}}, \code{\link{plot_outlier.data.frame}}.
}
\keyword{internal}
