% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pps.R
\name{plot.pps}
\alias{plot.pps}
\title{Visualize Information for an "pps" Object}
\usage{
\method{plot}{pps}(x, typographic = TRUE, base_family = NULL, ...)
}
\arguments{
\item{x}{an object of class "pps", usually, a result of a call to pps().}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).}
}
\value{
A ggplot2 object.
}
\description{
Visualize by attribute of `pps` class.
The plot of a PPS(Predictive Power Score) is a bar plot or tile plot by PPS.
}
\details{
The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
library(dplyr)

# If you want to use this feature, you need to install the 'ppsr' package.
if (!requireNamespace("ppsr", quietly = TRUE)) {
  cat("If you want to use this feature, you need to install the 'ppsr' package.\n")
}

# pps type is generic ======================================
pps_generic <- pps(iris)
pps_generic

if (!is.null(pps_generic)) {
  # visualize pps class 
  plot(pps_generic)
}

# pps type is target_by =====================================
##-----------------------------------------------------------
# If the target variable is a categorical variable
# Using dplyr
pps_cat <- iris \%>\% 
  target_by(Species) \%>\% 
  pps()

if (!is.null(pps_cat)) {
  # plot pps class
  plot(pps_cat)
}

##---------------------------------------------------
# If the target variable is a numerical variable
# Using dplyr
pps_num <- iris \%>\% 
  target_by(Petal.Length) \%>\% 
  pps()

if (!is.null(pps_num)) {
  # plot pps class
  plot(pps_num)
}

}
\seealso{
\code{\link{pps}}, \code{\link{summary.pps}}.
}
