% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rbind_list.R
\name{rbind_list}
\alias{rbind_list}
\title{Bind list of data frames and add list names as a column}
\usage{
rbind_list(lst, name = "name")
}
\arguments{
\item{lst}{A named list of data frames or tibbles.}

\item{name}{A character scalar: name of the column to hold the list names (default "name").}
}
\value{
A data frame or tibble, depending on the class of the input.
}
\description{
Binds a named list of data frames (or tibbles) into a single data frame.
Adds the list name as a new column (first column).
}
\examples{
lst <- list(a = data.frame(x = 1:2), b = data.frame(x = 3:4))
rbind_list(lst)

lst <- split(iris, iris$Species)
rbind_list(lst)


}
