% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiarm_binary.R
\name{ss_binary}
\alias{ss_binary}
\title{Total sample size for phase III trial with l treatments and equal allocation ratio for binary outcomes}
\usage{
ss_binary(alpha, beta, p0, p11, y, l)
}
\arguments{
\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{p0}{assumed true rate of control group}

\item{p11}{assumed true rate of treatment group}

\item{y}{hat_theta_2; estimator in phase II}

\item{l}{number of treatments in phase III:
\itemize{
\item l=1: according to Schoenfeld to guarantee power for the log rank test to detect treatment effect of phase II;
\item l=2: according to Dunnett to guarantee y any-pair power (Horn & Vollandt)
}}
}
\value{
the function ss_binary() returns the total sample size for phase III trial with l treatments and equal allocation ratio
}
\description{
Depending on the results of phase II and our strategy ,i.e. whether we proceed only with the best promising treatment (l = 1) or with all promising treatments (l = 2), this program calculates the number of participants in phase III.

l=1: according to Schoenfeld to guarantee power for the log rank test to detect treatment effect of phase II;

l=2: according to Dunnett to guarantee y any-pair power (Horn & Vollandt)
}
\examples{
res <- ss_binary(alpha = 0.05, beta = 0.1, p0 = 0.6, p11 = 0.3, y = 0.5, l = 1)
}
\keyword{internal}
