% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{exp_num_dt}
\alias{exp_num_dt}
\title{Data from an experiment with numeracy and date-time variables}
\format{
A table with 1000 cases (rows) and 15 variables (columns).
}
\source{
See CSV data files at 
\url{http://rpository.com/ds4psy/data/numeracy.csv} and 
\url{http://rpository.com/ds4psy/data/dt.csv}.
}
\usage{
exp_num_dt
}
\description{
\code{exp_num_dt} is a fictitious set of data describing 
1000 non-existing, but surprisingly friendly people.
}
\details{
\strong{Codebook} 
The data characterize 1000 individuals (rows) in 15 variables (columns):

\itemize{

\item 1. \strong{name}: Participant initials.

\item 2. \strong{gender}: Self-identified gender (as a binary variable).

\item 3. \strong{bday}: Day (within month) of DOB.

\item 4. \strong{bmonth}: Month (within year) of DOB.

\item 5. \strong{byear}: Year of DOB.

\item 6. \strong{height}: Height (in cm).

\item 7. \strong{blood_type}: Blood type. 
 
\item 8. \strong{bnt_1} to 11. \strong{bnt_4}: 
Correct response to corresponding BNT question? 
(1: correct, 0: incorrect).

\item 12. \strong{g_iq} and 13. \strong{s_iq}: 
Scores from two IQ tests (general vs. social).

\item 14. \strong{t_1} and 15. \strong{t_2}: 
Study start and end time.

} 

\code{exp_num_dt} was generated for practice purposes. 
It allows 
(1) converting data tables from wider into longer format, 
(2) dealing with date- and time-related variables, and 
(3) computing, analyzing, and visualizing test scores (e.g., numeracy, IQ). 

The \code{gender} variable was converted into a binary variable 
(i.e., using 2 categories "female" and "not female").
}
\seealso{
Other datasets: 
\code{\link{Bushisms}},
\code{\link{Trumpisms}},
\code{\link{countries}},
\code{\link{data_1}},
\code{\link{data_2}},
\code{\link{data_t1}},
\code{\link{data_t1_de}},
\code{\link{data_t1_tab}},
\code{\link{data_t2}},
\code{\link{data_t3}},
\code{\link{data_t4}},
\code{\link{dt_10}},
\code{\link{exp_wide}},
\code{\link{falsePosPsy_all}},
\code{\link{fame}},
\code{\link{flowery}},
\code{\link{fruits}},
\code{\link{i2ds_survey}},
\code{\link{outliers}},
\code{\link{pi_100k}},
\code{\link{posPsy_AHI_CESD}},
\code{\link{posPsy_long}},
\code{\link{posPsy_p_info}},
\code{\link{posPsy_wide}},
\code{\link{t3}},
\code{\link{t4}},
\code{\link{t_1}},
\code{\link{t_2}},
\code{\link{t_3}},
\code{\link{t_4}},
\code{\link{table6}},
\code{\link{table7}},
\code{\link{table8}},
\code{\link{table9}},
\code{\link{tb}}
}
\concept{datasets}
\keyword{datasets}
