//===----------------------------------------------------------------------===//
//                         DuckDB
//
// function/scalar/string_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct UpperFun {
	static constexpr const char *Name = "upper";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Convert string to upper case.";
	static constexpr const char *Example = "upper('Hello')";

	static ScalarFunction GetFunction();
};

struct UcaseFun {
	using ALIAS = UpperFun;

	static constexpr const char *Name = "ucase";
};

struct LowerFun {
	static constexpr const char *Name = "lower";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Convert string to lower case";
	static constexpr const char *Example = "lower('Hello')";

	static ScalarFunction GetFunction();
};

struct LcaseFun {
	using ALIAS = LowerFun;

	static constexpr const char *Name = "lcase";
};

struct ConcatWsFun {
	static constexpr const char *Name = "concat_ws";
	static constexpr const char *Parameters = "separator,string,...";
	static constexpr const char *Description = "Concatenate strings together separated by the specified separator.";
	static constexpr const char *Example = "concat_ws(', ', 'Banana', 'Apple', 'Melon')";

	static ScalarFunction GetFunction();
};

struct ConcatFun {
	static constexpr const char *Name = "concat";
	static constexpr const char *Parameters = "string,...";
	static constexpr const char *Description = "Concatenate many strings together.";
	static constexpr const char *Example = "concat('Hello', ' ', 'World')";

	static ScalarFunction GetFunction();
};

struct ListConcatFun {
	static constexpr const char *Name = "list_concat";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Concatenates two lists.";
	static constexpr const char *Example = "list_concat([2, 3], [4, 5, 6])";

	static ScalarFunction GetFunction();
};

struct ListCatFun {
	using ALIAS = ListConcatFun;

	static constexpr const char *Name = "list_cat";
};

struct ArrayConcatFun {
	using ALIAS = ListConcatFun;

	static constexpr const char *Name = "array_concat";
};

struct ArrayCatFun {
	using ALIAS = ListConcatFun;

	static constexpr const char *Name = "array_cat";
};

struct ConcatOperatorFun {
	static constexpr const char *Name = "||";
	static constexpr const char *Parameters = "list1,list2";
	static constexpr const char *Description = "Concatenates two lists.";
	static constexpr const char *Example = "list_concat([2, 3], [4, 5, 6])";

	static ScalarFunction GetFunction();
};

struct PrefixFun {
	static constexpr const char *Name = "prefix";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";

	static ScalarFunction GetFunction();
};

struct SuffixFun {
	static constexpr const char *Name = "suffix";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";

	static ScalarFunction GetFunction();
};

struct EndsWithFun {
	using ALIAS = SuffixFun;

	static constexpr const char *Name = "ends_with";
};

struct ContainsFun {
	static constexpr const char *Name = "contains";
	static constexpr const char *Parameters = "string::VARCHAR,search_string::VARCHAR\1list::ANY[],element::ANY\1map::MAP(ANY,ANY),key::ANY";
	static constexpr const char *Description = "Returns true if search_string is found within string.\1Returns true if the list contains the element.\1Checks if a map contains a given key.";
	static constexpr const char *Example = "contains('abc', 'a')\1contains([1, 2, NULL], 1)\1contains(MAP {'key1': 10, 'key2': 20, 'key3': 30}, 'key2')";

	static ScalarFunctionSet GetFunctions();
};

struct StripAccentsFun {
	static constexpr const char *Name = "strip_accents";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Strips accents from string.";
	static constexpr const char *Example = "strip_accents('mühleisen')";

	static ScalarFunction GetFunction();
};

struct NFCNormalizeFun {
	static constexpr const char *Name = "nfc_normalize";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Convert string to Unicode NFC normalized string. Useful for comparisons and ordering if text data is mixed between NFC normalized and not.";
	static constexpr const char *Example = "nfc_normalize('ardèch')";

	static ScalarFunction GetFunction();
};

struct LengthFun {
	static constexpr const char *Name = "length";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Number of characters in string.";
	static constexpr const char *Example = "length('Hello🦆')";

	static ScalarFunctionSet GetFunctions();
};

struct LenFun {
	using ALIAS = LengthFun;

	static constexpr const char *Name = "len";
};

struct StrlenFun {
	static constexpr const char *Name = "strlen";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Number of bytes in string.";
	static constexpr const char *Example = "strlen('🦆')";

	static ScalarFunction GetFunction();
};

struct BitLengthFun {
	static constexpr const char *Name = "bit_length";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";

	static ScalarFunctionSet GetFunctions();
};

struct OctetLengthFun {
	static constexpr const char *Name = "octet_length";
	static constexpr const char *Parameters = "blob";
	static constexpr const char *Description = "Number of bytes in blob.";
	static constexpr const char *Example = "octet_length('\\xAA\\xBB'::BLOB)";

	static ScalarFunctionSet GetFunctions();
};

struct LengthGraphemeFun {
	static constexpr const char *Name = "length_grapheme";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Number of grapheme clusters in string.";
	static constexpr const char *Example = "length_grapheme('🤦🏼‍♂️🤦🏽‍♀️')";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayLengthFun {
	static constexpr const char *Name = "array_length";
	static constexpr const char *Parameters = "list";
	static constexpr const char *Description = "Returns the length of the list.";
	static constexpr const char *Example = "array_length([1,2,3])";

	static ScalarFunctionSet GetFunctions();
};

struct SubstringFun {
	static constexpr const char *Name = "substring";
	static constexpr const char *Parameters = "string,start,length";
	static constexpr const char *Description = "Extract substring of length characters starting from character start. Note that a start value of 1 refers to the first character of the string.";
	static constexpr const char *Example = "substring('Hello', 2, 2)";

	static ScalarFunctionSet GetFunctions();
};

struct SubstrFun {
	using ALIAS = SubstringFun;

	static constexpr const char *Name = "substr";
};

struct SubstringGraphemeFun {
	static constexpr const char *Name = "substring_grapheme";
	static constexpr const char *Parameters = "string,start,length";
	static constexpr const char *Description = "Extract substring of length grapheme clusters starting from character start. Note that a start value of 1 refers to the first character of the string.";
	static constexpr const char *Example = "substring_grapheme('🦆🤦🏼‍♂️🤦🏽‍♀️🦆', 3, 2)";

	static ScalarFunctionSet GetFunctions();
};

struct StringSplitFun {
	static constexpr const char *Name = "string_split";
	static constexpr const char *Parameters = "string,separator";
	static constexpr const char *Description = "Splits the string along the separator";
	static constexpr const char *Example = "string_split('hello-world', '-')";

	static ScalarFunction GetFunction();
};

struct StrSplitFun {
	using ALIAS = StringSplitFun;

	static constexpr const char *Name = "str_split";
};

struct StringToArrayFun {
	using ALIAS = StringSplitFun;

	static constexpr const char *Name = "string_to_array";
};

struct SplitFun {
	using ALIAS = StringSplitFun;

	static constexpr const char *Name = "split";
};

struct StringSplitRegexFun {
	static constexpr const char *Name = "string_split_regex";
	static constexpr const char *Parameters = "string,separator";
	static constexpr const char *Description = "Splits the string along the regex";
	static constexpr const char *Example = "string_split_regex('hello␣world; 42', ';?␣')";

	static ScalarFunctionSet GetFunctions();
};

struct StrSplitRegexFun {
	using ALIAS = StringSplitRegexFun;

	static constexpr const char *Name = "str_split_regex";
};

struct RegexpSplitToArrayFun {
	using ALIAS = StringSplitRegexFun;

	static constexpr const char *Name = "regexp_split_to_array";
};

struct RegexpFun {
	static constexpr const char *Name = "regexp_full_match";
	static constexpr const char *Parameters = "string,regex[,options]";
	static constexpr const char *Description = "Returns true if the entire string matches the regex. A set of optional options can be set.";
	static constexpr const char *Example = "regexp_full_match('anabanana', '(an)*')";

	static ScalarFunctionSet GetFunctions();
};

struct RegexpMatchesFun {
	static constexpr const char *Name = "regexp_matches";
	static constexpr const char *Parameters = "string,pattern[,options]";
	static constexpr const char *Description = "Returns true if string contains the regexp pattern, false otherwise. A set of optional options can be set.";
	static constexpr const char *Example = "regexp_matches('anabanana', '(an)*')";

	static ScalarFunctionSet GetFunctions();
};

struct RegexpReplaceFun {
	static constexpr const char *Name = "regexp_replace";
	static constexpr const char *Parameters = "string,pattern,replacement[,options]";
	static constexpr const char *Description = "If string contains the regexp pattern, replaces the matching part with replacement. A set of optional options can be set.";
	static constexpr const char *Example = "regexp_replace('hello', '[lo]', '-')";

	static ScalarFunctionSet GetFunctions();
};

struct RegexpExtractFun {
	static constexpr const char *Name = "regexp_extract";
	static constexpr const char *Parameters = "string,pattern[,group = 0][,options]";
	static constexpr const char *Description = "If string contains the regexp pattern, returns the capturing group specified by optional parameter group. The group must be a constant value. If no group is given, it defaults to 0. A set of optional options can be set.";
	static constexpr const char *Example = "regexp_extract('abc', '([a-z])(b)', 1)";

	static ScalarFunctionSet GetFunctions();
};

struct RegexpExtractAllFun {
	static constexpr const char *Name = "regexp_extract_all";
	static constexpr const char *Parameters = "string, regex[, group = 0][, options]";
	static constexpr const char *Description = "Split the string along the regex and extract all occurrences of group. A set of optional options can be set.";
	static constexpr const char *Example = "regexp_extract_all('hello_world', '([a-z ]+)_?', 1)";

	static ScalarFunctionSet GetFunctions();
};

struct RegexpEscapeFun {
	static constexpr const char *Name = "regexp_escape";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Escapes all potentially meaningful regexp characters in the input string";
	static constexpr const char *Example = "regexp_escape('https://duckdb.org')";

	static ScalarFunction GetFunction();
};

struct LikeFun {
	static constexpr const char *Name = "~~";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";

	static ScalarFunction GetFunction();
};

struct NotLikeFun {
	static constexpr const char *Name = "!~~";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";

	static ScalarFunction GetFunction();
};

struct GlobPatternFun {
	static constexpr const char *Name = "~~~";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";

	static ScalarFunction GetFunction();
};

struct ILikeFun {
	static constexpr const char *Name = "~~*";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";

	static ScalarFunction GetFunction();
};

struct NotILikeFun {
	static constexpr const char *Name = "!~~*";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";

	static ScalarFunction GetFunction();
};

struct LikeEscapeFun {
	static constexpr const char *Name = "like_escape";
	static constexpr const char *Parameters = "string,like_specifier,escape_character";
	static constexpr const char *Description = "Returns true if the string matches the like_specifier (see Pattern Matching) using case-sensitive matching. escape_character is used to search for wildcard characters in the string.";
	static constexpr const char *Example = "like_escape('a%c', 'a$%c', '$')";

	static ScalarFunction GetFunction();
};

struct NotLikeEscapeFun {
	static constexpr const char *Name = "not_like_escape";
	static constexpr const char *Parameters = "string,like_specifier,escape_character";
	static constexpr const char *Description = "Returns false if the string matches the like_specifier (see Pattern Matching) using case-sensitive matching. escape_character is used to search for wildcard characters in the string.";
	static constexpr const char *Example = "not_like_escape('a%c', 'a$%c', '$')";

	static ScalarFunction GetFunction();
};

struct IlikeEscapeFun {
	static constexpr const char *Name = "ilike_escape";
	static constexpr const char *Parameters = "string,like_specifier,escape_character";
	static constexpr const char *Description = "Returns true if the string matches the like_specifier (see Pattern Matching) using case-insensitive matching. escape_character is used to search for wildcard characters in the string.";
	static constexpr const char *Example = "ilike_escape('A%c', 'a$%C', '$')";

	static ScalarFunction GetFunction();
};

struct NotIlikeEscapeFun {
	static constexpr const char *Name = "not_ilike_escape";
	static constexpr const char *Parameters = "string,like_specifier,escape_character";
	static constexpr const char *Description = "Returns false if the string matches the like_specifier (see Pattern Matching) using case-insensitive matching. escape_character is used to search for wildcard characters in the string.";
	static constexpr const char *Example = "not_ilike_escape('A%c', 'a$%C', '$')";

	static ScalarFunction GetFunction();
};

struct MD5Fun {
	static constexpr const char *Name = "md5";
	static constexpr const char *Parameters = "value";
	static constexpr const char *Description = "Returns the MD5 hash of the value as a string";
	static constexpr const char *Example = "md5('123')";

	static ScalarFunctionSet GetFunctions();
};

struct MD5NumberFun {
	static constexpr const char *Name = "md5_number";
	static constexpr const char *Parameters = "value";
	static constexpr const char *Description = "Returns the MD5 hash of the value as an INT128";
	static constexpr const char *Example = "md5_number('123')";

	static ScalarFunctionSet GetFunctions();
};

struct SHA1Fun {
	static constexpr const char *Name = "sha1";
	static constexpr const char *Parameters = "value";
	static constexpr const char *Description = "Returns the SHA1 hash of the value";
	static constexpr const char *Example = "sha1('hello')";

	static ScalarFunctionSet GetFunctions();
};

struct SHA256Fun {
	static constexpr const char *Name = "sha256";
	static constexpr const char *Parameters = "value";
	static constexpr const char *Description = "Returns the SHA256 hash of the value";
	static constexpr const char *Example = "sha256('hello')";

	static ScalarFunctionSet GetFunctions();
};

} // namespace duckdb
