# Generated by 02-duckplyr_df-methods.R
#' @export
slice_tail.duckplyr_df <- function(.data, ..., n, prop, by = NULL) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    "No relational implementation for {.code slice_tail()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  slice_tail <- dplyr$slice_tail.data.frame
  out <- slice_tail(.data, ..., n = n, prop = prop, by = {{ by }})
  return(out)

  # dplyr implementation
  check_dots_empty0(...)

  size <- get_slice_size(n = n, prop = prop)
  idx <- function(n) {
    seq2(n - size(n) + 1, n)
  }

  dplyr_local_error_call()
  dplyr_local_slice_by_arg("by")

  slice(.data, idx(dplyr::n()), .by = {{ by }})
}

duckplyr_slice_tail <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- slice_tail(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
