% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixOperators.R
\name{edm2gram}
\alias{edm2gram}
\title{Linear Matrix Operator}
\usage{
edm2gram(D)
}
\arguments{
\item{D}{A Euclidean Distance Matrix}
}
\value{
G A Gram Matrix, where G = XX', and X is an nxp matrix containing the point configuration.
}
\description{
\code{edm2gram} Linear transformation of a Euclidean Distance Matrix to a Gram Matrix
}
\details{
While we specify that the input should be a Euclidean Distance Matrix (as this results in a Gram Matrix)
the domain of edm2gram is the set of all real symmetric matrices. This function is particularly useful
as it has the following property:

\deqn{edm2gram(D_{n}^{-}) = B_{n}^{+}} 

where \eqn{D_{n}^{-}} is the space of symmetric, hollow matrices, negative definite on the space spanned by \eqn{x'e = 0}
and \eqn{B_{n}^{+}} is the space of centered positive definite matrices. 

We can combine these two properties with a well known result: If D is a real symmetric matrix with 0 diagonal (call this matrix pre-EDM),
then D is a Euclidean Distance Matrix iff D is negative semi-definite on \eqn{D_{n}^{-}}.

Using this result, combined with the properties of edm2gram we therefore have that 
D is an EDM iff D is pre-EDM and \eqn{edm2gram{D}} is positive semi-definite.
}
\examples{
 
XY <- cbind(runif(100,0,1),runif(100,0,1))
D <- dist(XY)
edm2gram(as.matrix(D))

}
