% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-claude.R
\name{chat_claude}
\alias{chat_claude}
\title{Chat with an Anthropic Claude model}
\usage{
chat_claude(
  system_prompt = NULL,
  turns = NULL,
  max_tokens = 4096,
  model = NULL,
  api_args = list(),
  base_url = "https://api.anthropic.com/v1",
  api_key = anthropic_key(),
  echo = NULL
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{max_tokens}{Maximum number of tokens to generate before stopping.}

\item{model}{The model to use for the chat. The default, \code{NULL}, will pick
a reasonable default, and tell you about. We strongly recommend explicitly
choosing a model for all but the most casual use.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{api_key}{The API key to use for authentication. You generally should
not supply this directly, but instead set the \code{ANTHROPIC_API_KEY} environment
variable.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://www.anthropic.com}{Anthropic} provides a number of chat based
models under the \href{https://www.anthropic.com/claude}{Claude} moniker.
Note that a Claude Pro membership does not give you the ability to call
models via the API; instead, you will need to sign up (and pay for) a
\href{https://console.anthropic.com/}{developer account}
\subsection{Authentication}{

To authenticate, we recommend saving your
\href{https://console.anthropic.com/account/keys}{API key} to
the \code{ANTHROPIC_API_KEY} env var in your \code{.Renviron}
(which you can easily edit by calling \code{usethis::edit_r_environ()}).
}
}
\examples{
\dontshow{if (has_credentials("claude")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chat <- chat_claude()
chat$chat("Tell me three jokes about statisticians")
\dontshow{\}) # examplesIf}
}
\seealso{
Other chatbots: 
\code{\link{chat_bedrock}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_gemini}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
