% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{untidy}
\alias{untidy}
\title{Dare to be un-"tidy"!}
\description{
Users who use \pkg{emmeans} functions as part of a pipeline -- or post-process 
those results in some other way -- are likely missing some important information.
}
\details{
Your best bet is to display the actual results without any post-processing.
That's because \code{emmeans} and its relatives have their own \code{summary} 
and \code{print} methods that display annotations that may be helpful in
explaining what you have. If you just pipe the results into the next step,
those annotations are stripped away and you never see them. Statistical
analysis is not just a workflow; it is a discipline that involves care in
interpreting intermediate results, and thinking before moving on.
}
\examples{
neur.glm <- glm(Pain ~ Treatment + Sex + Age, family = binomial(),
            data = neuralgia)
            
### The actual results with annotations (e.g. ests are on logit scale):
emmeans(neur.glm, "Treatment")

### Post-processed results lose the annotations
if(requireNamespace("tibble")) {
    emmeans(neur.glm, "Treatment") |> tibble::as_tibble()
}

}
