% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agents.R, R/tool.R
\name{agents_smallworld}
\alias{agents_smallworld}
\alias{agents_from_edgelist}
\alias{get_network}
\alias{network}
\alias{get_agents_states}
\alias{add_virus_agent}
\alias{add_tool_agent}
\alias{has_virus}
\alias{has_tool}
\alias{change_state}
\alias{get_agents_tools}
\title{Load agents to a model}
\usage{
agents_smallworld(model, n, k, d, p)

agents_from_edgelist(model, source, target, size, directed)

get_network(model)

get_agents_states(model)

add_virus_agent(agent, model, virus, state_new = -99, queue = -99)

add_tool_agent(agent, model, tool, state_new = -99, queue = -99)

has_virus(agent, virus)

has_tool(agent, tool)

change_state(agent, model, state_new, queue = -99)

get_agents_tools(model)
}
\arguments{
\item{model}{Model object of class \link{epiworld_model}.}

\item{n, size}{Number of individuals in the population.}

\item{k}{Number of ties in the small world network.}

\item{d, directed}{Logical scalar. Whether the graph is directed or not.}

\item{p}{Probability of rewiring.}

\item{source, target}{Integer vectors describing the source and target of
in the edgelist.}

\item{agent}{Agent object of class \code{epiworld_agent}.}

\item{virus}{Virus object of class \code{epiworld_virus}.}

\item{state_new}{Integer scalar. New state of the agent after the action is executed.}

\item{queue}{Integer scalar. Change in the queuing system after the action is executed.}

\item{tool}{Tool object of class \code{epiworld_tool}.}
}
\value{
\itemize{
\item The 'agents_smallworld' function returns a model with the agents
loaded.
}

\itemize{
\item The \code{agents_from_edgelist} function returns an empty model of class
\code{epiworld_model}.
}

\itemize{
\item The \code{get_network} function returns a data frame with two columns
(\code{source} and \code{target}) describing the edgelist of the network.
}

\itemize{
\item \code{get_agents_states} returns an character vector with the states of the
agents by the end of the simulation.
}

\itemize{
\item The function \code{add_virus_agent} adds a virus to an agent and
returns the agent invisibly.
}

\itemize{
\item The function \code{add_tool_agent} adds a tool to an agent and
returns the agent invisibly.
}

\itemize{
\item The functions \code{has_virus} and \code{has_tool} return a logical scalar
indicating whether the agent has the virus/tool or not.
}

\itemize{
\item \code{get_agents_tools} returns a list of class \code{epiworld_agents_tools}
with \code{epiworld_tools} (list of lists).
}
}
\description{
These functions provide access to the network of the model. The network is
represented by an edgelist. The \code{agents_smallworld} function generates a
small world network with the Watts-Strogatz algorithm. The
\code{agents_from_edgelist} function loads a network from an edgelist.
The \code{get_network} function returns the edgelist of the network.
}
\details{
The \code{new_state} and \code{queue} parameters are optional. If they are not
provided, the agent will be updated with the default values of the virus/tool.
}
\examples{

# Initializing SIR model with agents_smallworld
sir <- ModelSIR(name = "COVID-19", prevalence = 0.01, transmission_rate = 0.9, 
                recovery_rate = 0.1)
agents_smallworld(
   sir,
   n = 1000, 
   k = 5,
   d = FALSE,
   p = .01
 )
run(sir, ndays = 100, seed = 1912)
sir

# We can also retrieve the network
net <- get_network(sir)
head(net)

# Simulating a bernoulli graph
set.seed(333)
n <- 1000
g <- matrix(runif(n ^ 2) < .01, nrow = n)
diag(g) <- FALSE
el <- which(g, arr.ind = TRUE) - 1L


# Generating an empty model
sir <- ModelSIR("COVID-19", .01, .8, .3)
agents_from_edgelist(
  sir,
  source = el[,1],
  target = el[,2],
  size   = n,
  directed = TRUE
)

# Running the simulation
run(sir, 50)

plot(sir)
}
