% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMeaslesQuarantine.R
\name{ModelMeaslesQuarantine}
\alias{ModelMeaslesQuarantine}
\alias{epiworld_measlesquarantine}
\title{Measles model with quarantine}
\usage{
ModelMeaslesQuarantine(
  n,
  prevalence = 1,
  contact_rate = 15/transmission_rate/(rash_period + prodromal_period),
  transmission_rate = 0.9,
  vax_efficacy = 0.99,
  vax_improved_recovery = 0.5,
  incubation_period = 12,
  prodromal_period = 4,
  rash_period = 3,
  days_undetected = 2,
  hospitalization_rate = 0.2,
  hospitalization_duration = 7,
  prop_vaccinated = 1 - 1/15,
  quarantine_days = 21,
  quarantine_willingness = 1
)
}
\arguments{
\item{n}{Number of agents in the model.}

\item{prevalence}{Initial number of agents with the virus.}

\item{contact_rate}{Average number of contacts per step.}

\item{transmission_rate}{Probability of transmission.}

\item{vax_efficacy}{Probability of vaccine efficacy.}

\item{vax_improved_recovery}{Increase in recovery rate due to vaccination.}

\item{incubation_period}{Average number of incubation days.}

\item{prodromal_period}{Average number of prodromal days.}

\item{rash_period}{Average number of rash days.}

\item{days_undetected}{Average number of days undetected.}

\item{hospitalization_rate}{Probability of hospitalization.}

\item{hospitalization_duration}{Average number of days in hospital.}

\item{prop_vaccinated}{Proportion of the population vaccinated.}

\item{quarantine_days}{Total duration of quarantine.}

\item{quarantine_willingness}{Probability of accepting quarantine.}
}
\value{
\itemize{
\item The \code{ModelMeaslesQuarantine} function returns a model of class \link{epiworld_model}.
}
}
\description{
The \code{ModelMeaslesQuarantine} function implements a connected version
of a Measles model with quarantine.
}
\details{
The basic reproductive number in Measles is estimated to be about 15.
By default, the contact rate of the model is set so that the R0 matches
15.
}
\examples{
# An in a school with low vaccination
model_measles <- ModelMeaslesQuarantine(
  n = 500,
  prevalence = 1,
  prop_vaccinated = 0.70
)

# Running and printing
run(model_measles, ndays = 100, seed = 1912)
model_measles

plot(model_measles)

}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRMixing}()},
\code{\link{ModelSIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSIRMixing}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\author{
This model was built as a response to the US Measles outbreak in 2025.
This is a collaboration between the University of Utah (ForeSITE center
grant) and the Utah Department of Health and Human Services.
}
\concept{Models}
