# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Helper Function for Seasonal SIRI Simulation
#'
#' This function is an internal one that does the aspatial simulations within
#' one population for one timestep, for any given season.
#'
#' @name aspatial_siri
#'
#' @param initial_pop A vector of length 8 showing the initial abundance for
#' each combination of stage and compartment.
#' @param season_length The length of the season in days.
#' @param mortality A vector of length 8 with the mortality rates for each
#' stage and compartment in the season in question.
#' @param transmission A vector of length 8 with the transmission rates for each
#' stage in the season in question.
#' @param recovery A vector of length 8 with the recovery rates for each
#' infected stage in the season in question.
#' @param fecundity A vector of length 8 with the fecundity for each
#' reproductive segment.
#' @param abundance_threshold A quasi-extinction threshold below which a
#' population becomes extinct.
#' @param carrying_capacity A single numeric that indicates the carrying
#' capacity of the population in this season.
#' @param season Either "breeding" or "non-breeding."
#' @return A vector of length 8 showing the abundance for each combination of
#' stage and compartment at the end of the season.
#'
#' @examples
#' aspatial_siri(
#'  initial_pop = c(50000, 50000, 0, 1, 0, 0, 0, 0),
#'  season_length = 100,
#'  mortality = c(0.004, 0, 0.00505, 0.00105, 0.004, 0, 0.0045, 5e-04),
#'  fecundity = c(0, 15/182, 0, 15/182, 0, 15/182, 0, 15/182),
#'  transmission = c(0.00002, 0.00001, 0, 0, 7.84e-06, 3.92e-06, 0, 0),
#'  recovery = c(0, 0, 0.05714286, 0.05714286, 0, 0, 0.1, 0.1),
#'  carrying_capacity = 150000,
#'  abundance_threshold = 10,
#'  season = "breeding"
#' )
#' @export
aspatial_siri <- function(initial_pop, season_length, mortality, transmission, recovery, fecundity, abundance_threshold, carrying_capacity, season) {
    .Call(`_epizootic_aspatial_siri`, initial_pop, season_length, mortality, transmission, recovery, fecundity, abundance_threshold, carrying_capacity, season)
}

