% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esgf.R
\name{get_data_node}
\alias{get_data_node}
\title{Get data nodes which store CMIP6 output}
\usage{
get_data_node(speed_test = FALSE, timeout = 3)
}
\arguments{
\item{speed_test}{If \code{TRUE}, use \code{\link[pingr:ping]{pingr::ping()}} to perform connection speed
test on each data node. A \code{ping} column is appended in returned
data.table which stores each data node response in milliseconds. This
feature needs pingr package already installed. Default: \code{FALSE}.}

\item{timeout}{Timeout for a ping response in seconds. Default: \code{3}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} of 2 or 3 (when \code{speed_test} is \code{TRUE})
columns:\tabular{lll}{
   Column \tab Type \tab Description \cr
   \code{data_node} \tab character \tab Web address of data node \cr
   \code{status} \tab character \tab Status of data node. \code{"UP"} means OK and \code{"DOWN"} means currently not available \cr
   \code{ping} \tab double \tab Data node response in milliseconds during speed test \cr
}
}
\description{
Get data nodes which store CMIP6 output
}
\examples{
\dontrun{
get_data_node()
}

}
