% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQ_functions.R
\name{make_dummies}
\alias{make_dummies}
\title{EQ_dummies}
\usage{
make_dummies(
  df,
  version = "5L",
  dim.names = c("mo", "sc", "ua", "pd", "ad"),
  drop_level_1 = TRUE,
  add_intercept = FALSE,
  incremental = FALSE,
  prepend = NULL,
  append = NULL,
  return_df = TRUE
)
}
\arguments{
\item{df}{data.frame containing EQ-5D health states.}

\item{version}{Either "3L" or "5L", to signify EQ-5D instrument version}

\item{dim.names}{A vector of dimension names to be used as names for output columns.}

\item{drop_level_1}{If set to FALSE, dummies for level 1 will be included. Defaults to TRUE.}

\item{add_intercept}{If set to TRUE, a column containing 1s will be appended. Defaults to FALSE.}

\item{incremental}{If set to TRUE, incremental dummies will be produced (e.g. MO = 3 will give mo2 = 1, mo3 = 1). Defaults to FALSE.}

\item{prepend}{Optional string to be prepended to column names.}

\item{append}{Optional string to be appended to column names.}

\item{return_df}{If set to TRUE, data.frame is returned, otherwise matrix. Defaults to TRUE.}
}
\value{
A data.frame of dummy variables
}
\description{
Make a data.frame of all EQ-5D dummies relevant for e.g. regression modeling.
}
\examples{
make_dummies(make_all_EQ_states('3L'), '3L')

make_dummies(df = make_all_EQ_states('3L'), 
             version =  '3L', 
             incremental = TRUE, 
             add_intercept = TRUE, 
             prepend = "d_")
}
