% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_search_items.R
\name{tidy_search_items}
\alias{tidy_search_items}
\title{Tidy search API response}
\usage{
tidy_search_items(resp)
}
\arguments{
\item{resp}{an S3 object of type `europeana_search_api`}
}
\value{
`data.table` with stacked results collected from the search api.
Each row corresponds to a Cultural Heritage Object.
}
\description{
Transforms API response to a tidy `data.table` for easier manipulation
}
\examples{
\dontshow{if (Sys.getenv("EUROPEANA_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
#set your API key with set_key(api_key = "XXXX")
resp <- query_search_api("arioch")
tidy_search_items(resp)
}
\dontshow{\}) # examplesIf}
}
