% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife-cuminc.R
\name{leaveOneOut.survival2}
\alias{leaveOneOut.survival2}
\title{Compute leave one out jackknife contributions of the survival function}
\usage{
leaveOneOut.survival2(object, times, mr)
}
\arguments{
\item{object}{A survfit object, with a single event (no competing risks)}

\item{times}{Times at which the survival is computed, must be length 1}

\item{mr}{Model response, the result of a call to Surv, or a matrix with two columns: "time" (observed follow up time) and "status" (0 = censored, 1 = event)}
}
\value{
A vector of jackknifed values of survival at time times
}
\description{
For each subject, the survival function is recomputed leaving that subject out.
This is the workhorse for \link{jackknife.survival2} and will generally not
be called by the user.
}
\examples{

sfit.surv <- survival::survfit(survival::Surv(time, status) ~ 1, data = colon)
mrs <- with(colon, Surv(time, status))
jackvals <- leaveOneOut.survival2(sfit.surv, times = 1000, mrs)
}
