% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENNreg_init.R
\name{ENNreg_init}
\alias{ENNreg_init}
\title{Parameter initialization for the ENNreg model}
\usage{
ENNreg_init(X, y, K, nstart = 100, c = 1)
}
\arguments{
\item{X}{Input matrix of size n x p, where n is the number of objects and p the number of
attributes.}

\item{y}{Vector of length n containing observations of the response variable.}

\item{K}{Number of prototypes.}

\item{nstart}{Number of random starts of the k-means algorithm (default: 100)}

\item{c}{Multiplicative coefficient applied to scale parameter gamma (defaut: 1)}
}
\value{
An object of class "ENNreg", which can be passed to function \code{\link{ENNreg}}.
}
\description{
\code{ENNreg_init} returns initial parameter values for the ENNreg model.
}
\details{
Prototypes are initialized by the k-means algorithm.
}
\examples{
## Boston dataset
library(MASS)
attach(Boston)
X <- as.matrix(scale(Boston[,1:13]))
y <- Boston[,14]
psi <- ENNreg_init(X,y,K=30)
}
\seealso{
\code{\link{ENNreg}}
}
\author{
Thierry Denoeux.
}
