% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.R
\name{nom.cc}
\alias{nom.cc}
\alias{cc_coef}
\alias{cramer_vf}
\alias{cramer_coef}
\alias{kendall_corr}
\alias{spearman_corr}
\alias{rs_corr}
\alias{nom.cramer}
\alias{ord.spearman}
\alias{ord.kendall}
\title{Association and Correlation}
\usage{
nom.cc(tab, correct = FALSE)

nom.cramer(tab, ...)

ord.spearman(tab, ...)

ord.kendall(tab, ...)

cc_coef(tab, correct = FALSE)

cramer_vf(tab, ...)

cramer_coef(tab, ...)

kendall_corr(tab, ...)

spearman_corr(tab, ...)

rs_corr(tab, ...)
}
\arguments{
\item{tab}{table: contingency table with absolute frequencies}

\item{correct}{logical: if a correction should be applied (default: \code{FALSE})}

\item{...}{further parameters}
}
\value{
numeric
}
\description{
Computation of the following association and correlation measures:
\itemize{
\item \code{nom.cc} (corrected) contingency coefficient
\item \code{nom.cramer} Cramer's V or Phi
\item \code{ord.spearman} Spearman's rank correlation
\item \code{ord.kendall} Kendall's rank correlation
}
}
\examples{
tab <- matrix(round(10*runif(15)), ncol=5)
nom.cc(tab)
nom.cc(tab, correct=TRUE)
nom.cramer(tab)
ord.spearman(tab)
ord.kendall(tab)
}
