\name{exams2canvas}
\alias{exams2canvas}

\title{Generation of Exams for Canvas}

\description{
  Automatic generation of exams in QTI 1.2 with some tweaks
  (still under development) for the learning management system Canvas.
}

\usage{
  exams2canvas(file, n = 1L, dir = ".", name = "canvasquiz",
    maxattempts = 1, duration = NULL, points = NULL,
    converter = "pandoc-mathjax", template = "canvas_qti12.xml",
    quiztype = "assignment", \dots)
}

\arguments{
  \item{file}{character. A specification of a (list of) exercise files.}
  \item{n}{integer. The number of copies to be compiled from \code{file}.}
  \item{dir}{character. The default is the current working directory.}
  \item{name}{character. A name prefix for resulting exercises and ZIP file.}
  \item{maxattempts}{integer. The maximum attempts for one question
    (must be smaller than \code{100000}).}
  \item{duration}{integer. Set the duration of the exam in minutes.}
  \item{points}{integer. How many points should be assigned to each exercise? Note that this
    argument overules any exercise points that are provided within an \code{"\expoints{}"} tag
    in the \code{.Rnw} file. The vector of points supplied is expanded to the number of exercises in
    the exam.}
  \item{converter}{character passed on to \code{\link[exams]{make_exercise_transform_html}},
    indicating the type of converter from LaTeX/Markdown to HTML.}
  \item{template}{character. The IMS QTI 1.2 template that should be used.}
  \item{quiztype}{character. The type of quiz that should be created in Canvas.
    Defaults to \code{"assignment"} with alternative values being \code{"practice_quiz"},
    \code{"graded_survey"}, or \code{"survey"}.}
  \item{\dots}{arguments passed on to \code{\link[exams]{exams2qti12}}.
    The arguments \code{base64} and \code{eval} cannot be modified but are
    hard-coded internally (for details see below).}
}

\details{
  \code{exams2canvas} is a convenience interface to \code{\link[exams]{exams2qti12}}
  for generating QTI 1.2 with some small tweaks for Canvas
  (\url{https://www.instructure.com/canvas}). The supported exercise types at the
  moment are num, schoice, mchoice, and string. There is limited support for cloze exercises
  with multiple dropdown menus, i.e., schoice elements placed in the text with ANSWERi tags.
  
  The Canvas-specific tweaks include:
  \itemize{
    \item Canvas needs a \code{converter} that produces HTML with mathematical notation
      that can be rendered by MathJax. Hence \code{"pandoc-mathjax"} is the default but
      \code{"pandoc-mathml"} (or \code{"ttm"} for exams with only R/LaTeX .Rnw exercises)
      works as well, albeit possibly with problems when imported from a quiz to the item
      bank.
    \item Supplementary files (images, data, ...) must be embedded without Base 64
      encoding. Thus, \code{base64 = FALSE} is hard-coded internally in \code{exams2canvas}.
    \item Multiple-choice exercises (referred to as multiple answer questions in Canvas)
      are always evaluated (aka scored) with partial credits in Canvas. Therefore,
      \code{eval = list(partial = TRUE, negative = FALSE)} is hard-coded internally
      in \code{exams2canvas}. Negative points are not supported in Canvas.
    \item The QTI XML file requires a few special tags which are enforced through
      \code{flavor = "canvas"} in \code{exams2qti12}.
  }
  
  \emph{Technical note:} For multiple-choice questions the QTI XML file produced by
  \code{exams2canvas} appears to encode an \dQuote{all-or-nothing} scheme without partial
  credits (i.e., \code{partial = FALSE}). However, this is necessary for Canvas to recognize
  the answer alternatives correctly. Despite this, Canvas always applies partial-credit
  evaluation (as explained above).
}

\value{
  \code{exams2canvas} returns a list of exams as generated by \code{\link[exams]{xexams}}.
}

\seealso{
  \code{\link[exams]{exams2qti12}}
}

\examples{
\donttest{
## load package and enforce par(ask = FALSE)
library("exams")
options(device.ask.default = FALSE)

## define an exams (= list of exercises)
myexam <- c(
  "boxplots.Rmd",
  "tstat.Rmd",
  "ttest.Rmd",
  "regression.Rmd",
  "relfreq.Rmd"
)

## output directory
dir.create(mydir <- tempfile())

## generate .zip with Canvas test in temporary directory
exams2canvas(myexam, n = 3, dir = mydir)
dir(mydir)
}
}

\keyword{utilities}
