% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log-lik.R
\name{log_lik_skewnorm}
\alias{log_lik_skewnorm}
\title{Skew Normal Log-Likelihood}
\usage{
log_lik_skewnorm(x, mean = 0, sd = 1, shape = 0)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{mean}{A numeric vector of the means.}

\item{sd}{A non-negative numeric vector of the standard deviations.}

\item{shape}{A numeric vector of shape.}
}
\value{
An numeric vector of the corresponding log-likelihoods.
}
\description{
Skew Normal Log-Likelihood
}
\examples{
\dontshow{if (requireNamespace("sn")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
log_lik_skewnorm(c(-2:2))
log_lik_skewnorm(c(-2:2), shape = -2)
log_lik_skewnorm(c(-2:2), shape = 2)
\dontshow{\}) # examplesIf}
}
\seealso{
Other log_lik_dist: 
\code{\link{log_lik_bern}()},
\code{\link{log_lik_beta_binom}()},
\code{\link{log_lik_binom}()},
\code{\link{log_lik_gamma}()},
\code{\link{log_lik_gamma_pois}()},
\code{\link{log_lik_gamma_pois_zi}()},
\code{\link{log_lik_lnorm}()},
\code{\link{log_lik_neg_binom}()},
\code{\link{log_lik_norm}()},
\code{\link{log_lik_pois}()},
\code{\link{log_lik_pois_zi}()},
\code{\link{log_lik_student}()}
}
\concept{log_lik_dist}
