% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-lpfilt.R
\name{lpfilt}
\alias{lpfilt}
\title{Lowpass filtering of time series data}
\usage{
lpfilt(eyeris, wp = 4, ws = 8, rp = 1, rs = 35, plot_freqz = FALSE)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} derived from \code{\link[=load]{load()}}.}

\item{wp}{The end of passband frequency in Hz (desired lowpass cutoff).}

\item{ws}{The start of stopband frequency in Hz (required lowpass cutoff).}

\item{rp}{Required maximal ripple within passband in dB.}

\item{rs}{Required minimal attenuation within stopband in dB.}

\item{plot_freqz}{Boolean flag for displaying filter frequency response.}
}
\value{
An \code{eyeris} object with a new column in \code{timeseries}:
\verb{pupil_raw_\{...\}_lpfilt}.
}
\description{
The intended use of this method is for smoothing, although by specifying
\code{wp} and \code{ws} differently one can achieve highpass or bandpass filtering
as well. However, only lowpass filtering should be done on pupillometry data.
}
\examples{
system.file("extdata", "memory.asc", package = "eyeris") |>
  eyeris::load_asc() |>
  eyeris::deblink(extend = 50) |>
  eyeris::detransient() |>
  eyeris::interpolate() |>
  eyeris::lpfilt(plot_freqz = TRUE) |>
  plot(seed = 0)

}
