% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach.R
\name{fastverse_extend}
\alias{fastverse_extend}
\title{Extend the fastverse}
\usage{
fastverse_extend(
  ...,
  install = FALSE,
  permanent = FALSE,
  check.conflicts = !isTRUE(getOption("fastverse.quiet")),
  topics = NULL,
  repos = getOption("repos")
)
}
\arguments{
\item{\dots}{comma-separated package names, quoted or unquoted, or vectors of package names.}

\item{install}{logical. Install packages not available?}

\item{permanent}{logical. Should packages be saved and included when \code{library(fastverse)} is called next time? Implemented via a config file saved to the package directory. The file will be removed if the \emph{fastverse} is reinstalled, and can be removed without reinstallation using \code{\link{fastverse_reset}}. Packages can be removed from the config file using \code{\link[=fastverse_detach]{fastverse_detach(..., permanent = TRUE)}}.}

\item{check.conflicts}{logical. Should conflicts between extension packages and attached packages be checked?}

\item{topics}{depreciated argument used to bulk-attach or install suggested extension packages prior to v0.3.0.}

\item{repos}{character vector. Base URL(s) of the repositories to use, e.g., the URL of a CRAN mirror such as \code{"https://cloud.r-project.org"}. 
The macro \code{.fastverse_repos} contains the URL of the \href{https://fastverse.r-universe.dev}{fastverse r-universe server} to check/install the development version of packages.}
}
\value{
\code{fastverse_extend} returns \code{NULL} invisibly.
}
\description{
Loads additional packages as part of the \emph{fastverse}. By default only for the session, but extensions can be saved up to reinstallation/updating of the \emph{fastverse} package.
}
\details{
The \emph{fastverse} can be extended using a free choice of packages. An overview of high-performing packages for various tasks is provided in the \href{https://github.com/fastverse/fastverse#suggested-extensions}{README} file.  %, packages listed under \code{topics}, or a combination of both. If \code{install = FALSE}, only packages 
% among the \code{topics} groups that are available are considered, others are disregarded. 

When the \emph{fastverse} is extended calling \code{fastverse_extend(...)}, the packages that are not attached are attached, but conflicts are checked for all specified packages. 
If \code{permanent = FALSE}, an \code{options("fastverse.extend")} is set which stores these extension packages, regardless of whether they were already attached or not. When calling 
\code{\link{fastverse_packages}}, \code{\link{fastverse_deps}}, \code{\link{fastverse_conflicts}}, \code{\link{fastverse_update}}, \code{\link{fastverse_sitrep}} or \code{\link{fastverse_detach}}, these packages are included as part of the \emph{fastverse}. 
This is also the case if \code{permanent = TRUE}, with the only difference that instead of populating the option, a file is saved to the package directory such that the packages are also loaded
(as part of the core \emph{fastverse}) when calling \code{library(fastverse)} in the next session. To extend the \emph{fastverse} for the current session when it is not yet loaded, users can also set \code{options(fastverse.extend = c(...))}, where \code{c(...)}
is a character vector of package names, before calling \code{library(fastverse)}.
}
\examples{
# fastverse_extend(xts, stringi, fasttime)
}
\seealso{
\code{\link{fastverse_detach}}, \code{\link{fastverse}}
}
